// Code generated by boomtown. DO NOT EDIT.
// Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
// Arista Networks, Inc. Confidential and Proprietary.
// Subject to Arista Networks, Inc.'s EULA.
// FOR INTERNAL USE ONLY. NOT FOR DISTRIBUTION.

package hooks

import (
	"context"
	"time"

	api "arista/aeris/apiserver/client"
	pb "arista/codec/protobuf/gen"
	"arista/resources/arista/segmentation.v1"
	rclient "arista/resources/client"
	"arista/types"

	"github.com/aristanetworks/cloudvision-go/api/arista/subscriptions"
	"github.com/aristanetworks/goarista/key"
	"google.golang.org/grpc"
	"google.golang.org/grpc/codes"
	"google.golang.org/grpc/status"
)

// ApplicationConfigBase is an interface that provides the Aeris connection.
type ApplicationConfigBase interface {
	// Connection returns the connection being used to read from Aeris.
	// This connection is only used by the runner for subscriptions,
	// but should be readily available or constructible.
	Connection() *grpc.ClientConn
}

// ApplicationConfigMapper is an interface that declares where from Aeris to read data.
type ApplicationConfigMapper interface {

	// PathOf is given a request and is expected to return a valid Aeris path to the object.
	//
	// This result is used purely internally for KeyOf and Get. Only these methods needs
	// to interpret this path+keys, so the returned result can be an implementation detail.
	// Implementations are free to use or ignore the key array as necessary.
	//
	// If the path cannot be constructed, an error should be returned. This error will be logged
	// and an Internal error will be sent to the client.
	PathOf(context.Context, *segmentation.ApplicationKey) (key.Path, []key.Key,
		error)
	// KeyOf is given an Aeris path (generally from an update notif) and is expected to return a
	// valid ApplicationKey to return to the client.
	//
	// If the key struct cannot be constructed, an error should be returned.
	// This error will be logged and an Internal error will be sent to the client.
	KeyOf(context.Context, key.Path, key.Key) (*segmentation.ApplicationKey, error)

	// SubscribeRequests takes the stream request and returns information about 0 or
	// more Aeris subscriptions which should be initiated and run until either
	// completion or cancellation of the request context.
	//
	// This function should heavily consider optimizations of this request,
	// especially as it pertains to subscriptions. Examples:
	//
	//     - single filter + has key           -> subscribe to single path
	//     - many filters  + all have keys     -> subscribe to N paths (but not all)
	//     - many filters  + not all have keys -> subscribe to all (avoid dupes)
	//
	// This function is given the context from the request as well as the request
	// to the method which spawned this call. The passed in request should be
	// expected to be the {Resource}StreamRequest as defined in your proto.
	//
	// If the returned slice is empty, the runner will assume there is no work to
	// be done and the streaming handler will return, closing the stream to the client.
	//
	// All results of the subscription(s) are passed through Reader.FormatUpdate
	// before being sent to the client.
	SubscribeRequests(context.Context, *segmentation.ApplicationConfigStreamRequest) []rclient.SubscribeInfo
}

// ApplicationConfigAndTs is a struct that contains the ApplicationConfig value & time
type ApplicationConfigAndTs struct {
	Value *segmentation.ApplicationConfig
	Time  time.Time
}

// ApplicationConfigAndOperation holds a ApplicationConfig and subscriptions.Operation.
type ApplicationConfigAndOperation struct {
	Value     *segmentation.ApplicationConfig
	Operation subscriptions.Operation
}

// ApplicationConfigReader is an interface which abstracts how your resource can be read from
// Aeris (which may differ drastically from how it writes).
type ApplicationConfigReader interface {
	// Because the hook runner only uses the Reader and Writer interface,
	// the type implementing this interface must also implement Mapper.
	ApplicationConfigMapper

	// AllowGetAll allows the rpc to expose the GetAll method, while also being able to specify
	// that it is currently unsupported (but may be at a later date) and provide the relevant
	// response code for why.
	//
	// In practice, this should almost always return codes.OK, however, there may be concerns over
	// the scale (or technical unfeasability) of gathering the data.
	//
	// If this function does return any error code, the rationale and behavior should be properly
	// documented for clients so they do no expect results from this method.
	AllowGetAll(context.Context) codes.Code

	// ValidSubscribe is given the ApplicationConfigStreamRequest received by the server and is expected
	// to verify that this operation is valid/allowed. Validation may include (but not limited to):
	//
	//     - are subscriptions allowed on this resource with/without filters
	//     - do filters contain disallowed fields
	//     - do time-range parameters make sense
	//
	// The message contained in a returned error will be sent to the client. This message
	// should sufficiently explain how the user can correct the issue, but not so verbose
	// as to expose implementation and/or internal details. Logging should be used for
	// more informative errors.
	ValidateSubscribe(context.Context, *segmentation.ApplicationConfigStreamRequest) *status.Status

	// FormatUpdate is called on each notification in a notification batch
	// returned by a subscription and returns a series of ApplicationConfig and operation
	// to be tested by the filter. The operation should never be set to
	// INITIAL_SYNC_COMPLETE as this operation is handled by the calling code. If
	// the operation is not set (i.e. it's UNSPECIFIED), then the calling code
	// sets it to either INITIAL or UPDATED depending on the subscription phase.
	// This phase is indicated by the first parameter; if true, it indicates that
	// the update is initial state and, if false, that it is non-initial state.
	//
	// It is up to the implementor to extract the model's key(s) from the notification.
	// Similarly, you must call .Updates() to get the modified fields and you
	// may also optionally inspect the timestamp if re-ordering is required.
	//
	// Deletes contained in this notification should be ignored as they are
	// passed to FormatDelete rather than this method.
	//
	// To drop a notification, return an empty slice.
	// Returned errors will be logged, but will not terminate the subscription.
	FormatUpdate(context.Context, bool, types.Notification) ([]ApplicationConfigAndOperation, error)

	// OnInitialSyncComplete is called just before a subscription indicates to
	// the client that the initial state has all been sent. This method gives
	// the implementor a chance to send any additional resources that it may
	// have been holding onto.
	OnInitialSyncComplete(context.Context) ([]*ApplicationConfigAndTs, error)

	// Get fetches a single entity from Aeris.
	// The given Path is the result of calling MakePath. The Options struct is derived
	// from the request by the hooks-runner and can (generally) be passed to the Aeris client.
	// Implementors are allowed to modify the options so long as they respect what was given
	// in the request.
	//
	// Returning nil indicates that the resource does not exist and NotFound will be
	// returned to the client.
	//
	// The returned timestamp must be either (in order of precedence):
	//
	//     1. the timestamp received within the notification for this read (if applicable)
	//     2. the End timestamp within client.Options (if set)
	//     3. the time immediately after the read operation returned
	//
	// This convention allows the returned timestamp to always return a
	// relevant entry when the returned time is used as an End parameter to a later fetch.
	//
	// The message contained in a returned error will be sent to the client. This message
	// should sufficiently explain how the user can correct the issue, but not so verbose
	// as to expose implementation and/or internal details. Logging should be used for
	// more informative errors.
	Get(
		context.Context,
		key.Path, []key.Key,
		*api.Options,
	) (*segmentation.ApplicationConfig, time.Time, *status.Status)

	// GetAll feeds all or a subset (based on the request filters) of the instances
	// of ApplicationConfig in Aeris to the client via the channel passed into the method.
	//
	// The client.Options argument is the result of converting the arista.time.TimeRange
	// in the request into options usable with Aeris clients.
	//
	// It is the responsibility of the implementer to close the channel passed to
	// GetAll before returning.
	//
	// Returning without sending on the channel results in no stream messages sent to the client.
	GetAll(context.Context, *segmentation.ApplicationConfigStreamRequest, *api.Options,
		chan<- ApplicationConfigAndTs) *status.Status
	// Subscribe hands control of the entire subscription over to an individual service, allowing
	// the service to do whatever it wants with the Subscribe() API, instead of the Aeris-specific
	// way most resource APIs deal with things. It will eventually be replaced with a suite of
	// gNMI-specific methods that can be called in a similar way to Aeris-specific interface methods
	Subscribe(ctx context.Context, req *segmentation.ApplicationConfigStreamRequest,
		stream segmentation.ApplicationConfigService_SubscribeServer) error
}

// ApplicationConfigGetSomeError is the key that failed to read and how it failed.
// This error is user-facing and should read as such.
type ApplicationConfigGetSomeError struct {
	Key   *segmentation.ApplicationKey
	Error error
}

// ApplicationConfigGetSomeOverride allows for writing a "custom" GetSome implementation
// that is more efficient than the default (calling Get(...) in a loop).
//
// The implementor should attempt to send all responses into the channel resp.
// The implementor should close the channel resp when all responses have been sent.
// Any significant error should be returned.
// Any error returned will lead to a "code.Internal" error status on the request.
type ApplicationConfigGetSomeOverride interface {
	GetSomeOverride(
		ctx context.Context,
		req *segmentation.ApplicationConfigSomeRequest,
		resp chan<- *segmentation.ApplicationConfigSomeResponse,
	) error
}

// ApplicationConfigSubscribeBookends allows for custom behavior at the beginning and end of each
// Subscribe call. This is useful, for instance, if you need maintain some state that
// only lasts the duration of the call.
type ApplicationConfigSubscribeBookends interface {
	// OnSubscribeStart is called at the beginning of Subscribe. It takes a pointer
	// to the context that was passed to Subscribe, allowing it to be overidden. E.g.,
	//
	// *ctx = context.WithValue(*ctx, ...)
	//
	// The Subscribe request is also passed to this method for additional context.
	OnSubscribeStart(ctx *context.Context, req *segmentation.ApplicationConfigStreamRequest) *status.Status
	// OnSubscribeEnd is called just before Subscribe ends.
	OnSubscribeEnd(ctx context.Context, req *segmentation.ApplicationConfigStreamRequest) error
}

// DeletedApplicationConfigAndTs is a struct that holds the delete error TypeAndError,
// ApplicationKey and time
type DeletedApplicationConfigAndTs struct {
	TypeAndError rclient.DeletionError
	Key          *segmentation.ApplicationKey
	Time         time.Time
}

type ApplicationConfigAllDeleter interface {
	// DeleteAllHandler is expected to delete every key in a resource collection.
	// When DeleteAllHandler is implemented, rpc DeleteAll will call DeleteAllHandler.
	// If all keys are deleted successfully, the service will close the RPC gracefully.
	// The returned timestamp will have the timestamp used when publishing to Aeris.
	//
	// It is the responsibility of the implementer to close the channel passed to
	// DeleteAllHandler before returning.
	//
	// If a service begins deleting data from storage and some keys are deleted but
	// others fail, it should return over a channel the DeleteError for the keys it fails
	// to delete in the DeleteResponse (in DeletedApplicationConfigAndTs).
	// If a service runs into any error before deleting any key, it will return
	// a single response with an appropriate DeleteError and error message,
	// without setting any key, and close the RPC.
	DeleteAllHandler(context.Context,
		*segmentation.ApplicationConfigDeleteAllRequest, chan<- DeletedApplicationConfigAndTs) *status.Status
}

type ApplicationConfigPathDeleter interface {
	// GetDeletePaths specifies a set of paths to delete and a dataset to delete from.
	// Wildcards are permitted.
	//
	// If all keys from the paths are deleted successfully,
	// the service will close the RPC gracefully.
	//
	// If a service begins deleting data from storage and some keys are deleted but others
	// fail, it should return the keys it fails to delete in the DeleteResponse
	//
	// If a service runs into any error before deleting any key, it will
	// return a single response with an appropriate DeleteError and error message,
	// without setting any key, and close the RPC.
	GetDeletePaths(context.Context) ([]key.Path, pb.Dataset, error)
}

// ApplicationConfigSetSomeError is the key that failed to write and how it failed.
// This error is user-facing and should read as such.
type ApplicationConfigSetSomeError struct {
	Key   *segmentation.ApplicationKey
	Error error
}

// ApplicationConfigSetSomeOverride allows for writing a "custom" SetSome implementation
// that is more efficient than the default (calling Write(...) in a loop).
//
// The implementor should attempt write all values into storage and return all errors that occur.
// The returned errors will be sent to the client so they should be user-approriate.
// Any errors returned will lead to a "code.Internal" error status on the request.
//
// When overriding, values __will not__ have been passed to ValidateWrite so this must be
// taken care of. While hooks-runner is capable of calling it, we'd have to track values
// which have and have not passed validation. This causes unnecessary memory usage for something
// that could just be returned as an error from this function.
type ApplicationConfigSetSomeOverride interface {
	SetSomeOverride(ctx context.Context, req *segmentation.ApplicationConfigSetSomeRequest) []ApplicationConfigSetSomeError
}

// ApplicationConfigDeleteSomeError is the key that failed to delete and how it failed.
// ApplicationConfigDeleteSomeError is only sent when there is an error.
// This error is user-facing and should read as such.
type ApplicationConfigDeleteSomeError struct {
	Key   *segmentation.ApplicationKey
	Error error
}

// ApplicationConfigDeleteSomeOverride allows for writing a "custom" DeleteSome implementation
// that is more efficient than the default (calling Delete(...) in a loop).
//
// The implementor should attempt delete all values from storage and return all errors that occur.
// The returned errors will be sent to the client so they should be user-approriate.
// Any errors returned will lead to a "code.Internal" error status on the request.
type ApplicationConfigDeleteSomeOverride interface {
	DeleteSomeOverride(ctx context.Context, req *segmentation.ApplicationConfigDeleteSomeRequest) []ApplicationConfigDeleteSomeError
}

// ApplicationConfigWriter is an abstraction over how your service will write resources into Aeris.
// All validation will be done before the call to Write or Delete, so those methods can
// simply implement the required action.
type ApplicationConfigWriter interface {
	// ValidateWrite is given the ApplicationConfig within a ApplicationConfigWriteRequest and is expected to
	// return any errors with the request. Validation may include (but not limited to):
	//
	//     - checking all required fields are given
	//     - provided fields are valid (format, contents, etc.)
	//     - if server-generated fields are given, handle as update
	//         - should probably only be allowed as part of the Key
	//         - verify validity/existence/etc to avoid accidental overwrites
	//
	// The message contained in a returned error will be sent to the client. This message
	// should sufficiently explain how the user can correct the issue, but not so verbose
	// as to expose implementation and/or internal details. Logging should be used for
	// more informative errors.
	ValidateWrite(context.Context, *segmentation.ApplicationConfig) error

	// Write is expected to write the given ApplicationConfig into Aeris (and do any data
	// transformations required to match Aeris' schema before writing).
	//
	// The entity from the request is passed as a pointer so that any modifications made to
	// it are echoed back to the client. This is ideal for server-generated values. Simply
	// set the values on the entity before converting to Aeris-form.
	//
	// The returned timestamp must be either the timestamp associated with the notification
	// sent to Aeris for this write (if applicable) or the time immediately after the write
	// operation returned. This convention allows the returned timestamp to always return a
	// valid entry when the returned time is used as an End parameter to a later fetch.
	//
	// The message contained in a returned error will be sent to the client. This message
	// should sufficiently explain how the user can correct the issue, but not so verbose
	// as to expose implementation and/or internal details. Logging should be used for
	// more informative errors.
	Write(context.Context, *segmentation.ApplicationConfig) (time.Time, *status.Status)
	// Delete is expected to delete the entity within Aeris identified by the given key.
	//
	// The returned timestamp should be the same as the timestamp used when publishing
	// to Aeris. This allows clients to have a minimal timestamp for which the deleted
	// entity will not exist in future queries.
	//
	// The message contained in a returned error will be sent to the client. This message
	// should sufficiently explain how the user can correct the issue, but not so verbose
	// as to expose implementation and/or internal details. Logging should be used for
	// more informative errors.
	Delete(context.Context, *segmentation.ApplicationKey) (time.Time, *status.Status)
}

// DefaultActionConfigBase is an interface that provides the Aeris connection.
type DefaultActionConfigBase interface {
	// Connection returns the connection being used to read from Aeris.
	// This connection is only used by the runner for subscriptions,
	// but should be readily available or constructible.
	Connection() *grpc.ClientConn
}

// DefaultActionConfigMapper is an interface that declares where from Aeris to read data.
type DefaultActionConfigMapper interface {

	// PathOf is given a request and is expected to return a valid Aeris path to the object.
	//
	// This result is used purely internally for KeyOf and Get. Only these methods needs
	// to interpret this path+keys, so the returned result can be an implementation detail.
	// Implementations are free to use or ignore the key array as necessary.
	//
	// If the path cannot be constructed, an error should be returned. This error will be logged
	// and an Internal error will be sent to the client.
	PathOf(context.Context) (key.Path, []key.Key,
		error)

	// SubscribeRequests takes the stream request and returns information about 0 or
	// more Aeris subscriptions which should be initiated and run until either
	// completion or cancellation of the request context.
	//
	// This function should heavily consider optimizations of this request,
	// especially as it pertains to subscriptions. Examples:
	//
	//     - single filter + has key           -> subscribe to single path
	//     - many filters  + all have keys     -> subscribe to N paths (but not all)
	//     - many filters  + not all have keys -> subscribe to all (avoid dupes)
	//
	// This function is given the context from the request as well as the request
	// to the method which spawned this call. The passed in request should be
	// expected to be the {Resource}StreamRequest as defined in your proto.
	//
	// If the returned slice is empty, the runner will assume there is no work to
	// be done and the streaming handler will return, closing the stream to the client.
	//
	// All results of the subscription(s) are passed through Reader.FormatUpdate
	// before being sent to the client.
	SubscribeRequests(context.Context, *segmentation.DefaultActionConfigStreamRequest) []rclient.SubscribeInfo
}

// DefaultActionConfigAndTs is a struct that contains the DefaultActionConfig value & time
type DefaultActionConfigAndTs struct {
	Value *segmentation.DefaultActionConfig
	Time  time.Time
}

// DefaultActionConfigAndOperation holds a DefaultActionConfig and subscriptions.Operation.
type DefaultActionConfigAndOperation struct {
	Value     *segmentation.DefaultActionConfig
	Operation subscriptions.Operation
}

// DefaultActionConfigReader is an interface which abstracts how your resource can be read from
// Aeris (which may differ drastically from how it writes).
type DefaultActionConfigReader interface {
	// Because the hook runner only uses the Reader and Writer interface,
	// the type implementing this interface must also implement Mapper.
	DefaultActionConfigMapper

	// AllowGetAll allows the rpc to expose the GetAll method, while also being able to specify
	// that it is currently unsupported (but may be at a later date) and provide the relevant
	// response code for why.
	//
	// In practice, this should almost always return codes.OK, however, there may be concerns over
	// the scale (or technical unfeasability) of gathering the data.
	//
	// If this function does return any error code, the rationale and behavior should be properly
	// documented for clients so they do no expect results from this method.
	AllowGetAll(context.Context) codes.Code

	// ValidSubscribe is given the DefaultActionConfigStreamRequest received by the server and is expected
	// to verify that this operation is valid/allowed. Validation may include (but not limited to):
	//
	//     - are subscriptions allowed on this resource with/without filters
	//     - do filters contain disallowed fields
	//     - do time-range parameters make sense
	//
	// The message contained in a returned error will be sent to the client. This message
	// should sufficiently explain how the user can correct the issue, but not so verbose
	// as to expose implementation and/or internal details. Logging should be used for
	// more informative errors.
	ValidateSubscribe(context.Context, *segmentation.DefaultActionConfigStreamRequest) *status.Status

	// FormatUpdate is called on each notification in a notification batch
	// returned by a subscription and returns a series of DefaultActionConfig and operation
	// to be tested by the filter. The operation should never be set to
	// INITIAL_SYNC_COMPLETE as this operation is handled by the calling code. If
	// the operation is not set (i.e. it's UNSPECIFIED), then the calling code
	// sets it to either INITIAL or UPDATED depending on the subscription phase.
	// This phase is indicated by the first parameter; if true, it indicates that
	// the update is initial state and, if false, that it is non-initial state.
	//
	// It is up to the implementor to extract the model's key(s) from the notification.
	// Similarly, you must call .Updates() to get the modified fields and you
	// may also optionally inspect the timestamp if re-ordering is required.
	//
	// Deletes contained in this notification should be ignored as they are
	// passed to FormatDelete rather than this method.
	//
	// To drop a notification, return an empty slice.
	// Returned errors will be logged, but will not terminate the subscription.
	FormatUpdate(context.Context, bool, types.Notification) ([]DefaultActionConfigAndOperation, error)

	// OnInitialSyncComplete is called just before a subscription indicates to
	// the client that the initial state has all been sent. This method gives
	// the implementor a chance to send any additional resources that it may
	// have been holding onto.
	OnInitialSyncComplete(context.Context) ([]*DefaultActionConfigAndTs, error)

	// Get fetches a single entity from Aeris.
	// The given Path is the result of calling MakePath. The Options struct is derived
	// from the request by the hooks-runner and can (generally) be passed to the Aeris client.
	// Implementors are allowed to modify the options so long as they respect what was given
	// in the request.
	//
	// Returning nil indicates that the resource does not exist and NotFound will be
	// returned to the client.
	//
	// The returned timestamp must be either (in order of precedence):
	//
	//     1. the timestamp received within the notification for this read (if applicable)
	//     2. the End timestamp within client.Options (if set)
	//     3. the time immediately after the read operation returned
	//
	// This convention allows the returned timestamp to always return a
	// relevant entry when the returned time is used as an End parameter to a later fetch.
	//
	// The message contained in a returned error will be sent to the client. This message
	// should sufficiently explain how the user can correct the issue, but not so verbose
	// as to expose implementation and/or internal details. Logging should be used for
	// more informative errors.
	Get(
		context.Context,
		key.Path, []key.Key,
		*api.Options,
	) (*segmentation.DefaultActionConfig, time.Time, *status.Status)

	// GetAll feeds all or a subset (based on the request filters) of the instances
	// of DefaultActionConfig in Aeris to the client via the channel passed into the method.
	//
	// The client.Options argument is the result of converting the arista.time.TimeRange
	// in the request into options usable with Aeris clients.
	//
	// It is the responsibility of the implementer to close the channel passed to
	// GetAll before returning.
	//
	// Returning without sending on the channel results in no stream messages sent to the client.
	GetAll(context.Context, *segmentation.DefaultActionConfigStreamRequest, *api.Options,
		chan<- DefaultActionConfigAndTs) *status.Status
	// Subscribe hands control of the entire subscription over to an individual service, allowing
	// the service to do whatever it wants with the Subscribe() API, instead of the Aeris-specific
	// way most resource APIs deal with things. It will eventually be replaced with a suite of
	// gNMI-specific methods that can be called in a similar way to Aeris-specific interface methods
	Subscribe(ctx context.Context, req *segmentation.DefaultActionConfigStreamRequest,
		stream segmentation.DefaultActionConfigService_SubscribeServer) error
}

// DefaultActionConfigSubscribeBookends allows for custom behavior at the beginning and end of each
// Subscribe call. This is useful, for instance, if you need maintain some state that
// only lasts the duration of the call.
type DefaultActionConfigSubscribeBookends interface {
	// OnSubscribeStart is called at the beginning of Subscribe. It takes a pointer
	// to the context that was passed to Subscribe, allowing it to be overidden. E.g.,
	//
	// *ctx = context.WithValue(*ctx, ...)
	//
	// The Subscribe request is also passed to this method for additional context.
	OnSubscribeStart(ctx *context.Context, req *segmentation.DefaultActionConfigStreamRequest) *status.Status
	// OnSubscribeEnd is called just before Subscribe ends.
	OnSubscribeEnd(ctx context.Context, req *segmentation.DefaultActionConfigStreamRequest) error
}

// DefaultActionConfigWriter is an abstraction over how your service will write resources into Aeris.
// All validation will be done before the call to Write or Delete, so those methods can
// simply implement the required action.
type DefaultActionConfigWriter interface {
	// ValidateWrite is given the DefaultActionConfig within a DefaultActionConfigWriteRequest and is expected to
	// return any errors with the request. Validation may include (but not limited to):
	//
	//     - checking all required fields are given
	//     - provided fields are valid (format, contents, etc.)
	//     - if server-generated fields are given, handle as update
	//         - should probably only be allowed as part of the Key
	//         - verify validity/existence/etc to avoid accidental overwrites
	//
	// The message contained in a returned error will be sent to the client. This message
	// should sufficiently explain how the user can correct the issue, but not so verbose
	// as to expose implementation and/or internal details. Logging should be used for
	// more informative errors.
	ValidateWrite(context.Context, *segmentation.DefaultActionConfig) error

	// Write is expected to write the given DefaultActionConfig into Aeris (and do any data
	// transformations required to match Aeris' schema before writing).
	//
	// The entity from the request is passed as a pointer so that any modifications made to
	// it are echoed back to the client. This is ideal for server-generated values. Simply
	// set the values on the entity before converting to Aeris-form.
	//
	// The returned timestamp must be either the timestamp associated with the notification
	// sent to Aeris for this write (if applicable) or the time immediately after the write
	// operation returned. This convention allows the returned timestamp to always return a
	// valid entry when the returned time is used as an End parameter to a later fetch.
	//
	// The message contained in a returned error will be sent to the client. This message
	// should sufficiently explain how the user can correct the issue, but not so verbose
	// as to expose implementation and/or internal details. Logging should be used for
	// more informative errors.
	Write(context.Context, *segmentation.DefaultActionConfig) (time.Time, *status.Status)
}

// DomainBase is an interface that provides the Aeris connection.
type DomainBase interface {
	// Connection returns the connection being used to read from Aeris.
	// This connection is only used by the runner for subscriptions,
	// but should be readily available or constructible.
	Connection() *grpc.ClientConn
}

// DomainMapper is an interface that declares where from Aeris to read data.
type DomainMapper interface {

	// PathOf is given a request and is expected to return a valid Aeris path to the object.
	//
	// This result is used purely internally for KeyOf and Get. Only these methods needs
	// to interpret this path+keys, so the returned result can be an implementation detail.
	// Implementations are free to use or ignore the key array as necessary.
	//
	// If the path cannot be constructed, an error should be returned. This error will be logged
	// and an Internal error will be sent to the client.
	PathOf(context.Context, *segmentation.DomainKey) (key.Path, []key.Key,
		error)
	// KeyOf is given an Aeris path (generally from an update notif) and is expected to return a
	// valid DomainKey to return to the client.
	//
	// If the key struct cannot be constructed, an error should be returned.
	// This error will be logged and an Internal error will be sent to the client.
	KeyOf(context.Context, key.Path, key.Key) (*segmentation.DomainKey, error)

	// SubscribeRequests takes the stream request and returns information about 0 or
	// more Aeris subscriptions which should be initiated and run until either
	// completion or cancellation of the request context.
	//
	// This function should heavily consider optimizations of this request,
	// especially as it pertains to subscriptions. Examples:
	//
	//     - single filter + has key           -> subscribe to single path
	//     - many filters  + all have keys     -> subscribe to N paths (but not all)
	//     - many filters  + not all have keys -> subscribe to all (avoid dupes)
	//
	// This function is given the context from the request as well as the request
	// to the method which spawned this call. The passed in request should be
	// expected to be the {Resource}StreamRequest as defined in your proto.
	//
	// If the returned slice is empty, the runner will assume there is no work to
	// be done and the streaming handler will return, closing the stream to the client.
	//
	// All results of the subscription(s) are passed through Reader.FormatUpdate
	// before being sent to the client.
	SubscribeRequests(context.Context, *segmentation.DomainStreamRequest) []rclient.SubscribeInfo
}

// DomainAndTs is a struct that contains the Domain value & time
type DomainAndTs struct {
	Value *segmentation.Domain
	Time  time.Time
}

// DomainAndOperation holds a Domain and subscriptions.Operation.
type DomainAndOperation struct {
	Value     *segmentation.Domain
	Operation subscriptions.Operation
}

// DomainReader is an interface which abstracts how your resource can be read from
// Aeris (which may differ drastically from how it writes).
type DomainReader interface {
	// Because the hook runner only uses the Reader and Writer interface,
	// the type implementing this interface must also implement Mapper.
	DomainMapper

	// AllowGetAll allows the rpc to expose the GetAll method, while also being able to specify
	// that it is currently unsupported (but may be at a later date) and provide the relevant
	// response code for why.
	//
	// In practice, this should almost always return codes.OK, however, there may be concerns over
	// the scale (or technical unfeasability) of gathering the data.
	//
	// If this function does return any error code, the rationale and behavior should be properly
	// documented for clients so they do no expect results from this method.
	AllowGetAll(context.Context) codes.Code

	// ValidSubscribe is given the DomainStreamRequest received by the server and is expected
	// to verify that this operation is valid/allowed. Validation may include (but not limited to):
	//
	//     - are subscriptions allowed on this resource with/without filters
	//     - do filters contain disallowed fields
	//     - do time-range parameters make sense
	//
	// The message contained in a returned error will be sent to the client. This message
	// should sufficiently explain how the user can correct the issue, but not so verbose
	// as to expose implementation and/or internal details. Logging should be used for
	// more informative errors.
	ValidateSubscribe(context.Context, *segmentation.DomainStreamRequest) *status.Status

	// FormatUpdate is called on each notification in a notification batch
	// returned by a subscription and returns a series of Domain and operation
	// to be tested by the filter. The operation should never be set to
	// INITIAL_SYNC_COMPLETE as this operation is handled by the calling code. If
	// the operation is not set (i.e. it's UNSPECIFIED), then the calling code
	// sets it to either INITIAL or UPDATED depending on the subscription phase.
	// This phase is indicated by the first parameter; if true, it indicates that
	// the update is initial state and, if false, that it is non-initial state.
	//
	// It is up to the implementor to extract the model's key(s) from the notification.
	// Similarly, you must call .Updates() to get the modified fields and you
	// may also optionally inspect the timestamp if re-ordering is required.
	//
	// Deletes contained in this notification should be ignored as they are
	// passed to FormatDelete rather than this method.
	//
	// To drop a notification, return an empty slice.
	// Returned errors will be logged, but will not terminate the subscription.
	FormatUpdate(context.Context, bool, types.Notification) ([]DomainAndOperation, error)

	// OnInitialSyncComplete is called just before a subscription indicates to
	// the client that the initial state has all been sent. This method gives
	// the implementor a chance to send any additional resources that it may
	// have been holding onto.
	OnInitialSyncComplete(context.Context) ([]*DomainAndTs, error)

	// Get fetches a single entity from Aeris.
	// The given Path is the result of calling MakePath. The Options struct is derived
	// from the request by the hooks-runner and can (generally) be passed to the Aeris client.
	// Implementors are allowed to modify the options so long as they respect what was given
	// in the request.
	//
	// Returning nil indicates that the resource does not exist and NotFound will be
	// returned to the client.
	//
	// The returned timestamp must be either (in order of precedence):
	//
	//     1. the timestamp received within the notification for this read (if applicable)
	//     2. the End timestamp within client.Options (if set)
	//     3. the time immediately after the read operation returned
	//
	// This convention allows the returned timestamp to always return a
	// relevant entry when the returned time is used as an End parameter to a later fetch.
	//
	// The message contained in a returned error will be sent to the client. This message
	// should sufficiently explain how the user can correct the issue, but not so verbose
	// as to expose implementation and/or internal details. Logging should be used for
	// more informative errors.
	Get(
		context.Context,
		key.Path, []key.Key,
		*api.Options,
	) (*segmentation.Domain, time.Time, *status.Status)

	// GetAll feeds all or a subset (based on the request filters) of the instances
	// of Domain in Aeris to the client via the channel passed into the method.
	//
	// The client.Options argument is the result of converting the arista.time.TimeRange
	// in the request into options usable with Aeris clients.
	//
	// It is the responsibility of the implementer to close the channel passed to
	// GetAll before returning.
	//
	// Returning without sending on the channel results in no stream messages sent to the client.
	GetAll(context.Context, *segmentation.DomainStreamRequest, *api.Options,
		chan<- DomainAndTs) *status.Status
	// Subscribe hands control of the entire subscription over to an individual service, allowing
	// the service to do whatever it wants with the Subscribe() API, instead of the Aeris-specific
	// way most resource APIs deal with things. It will eventually be replaced with a suite of
	// gNMI-specific methods that can be called in a similar way to Aeris-specific interface methods
	Subscribe(ctx context.Context, req *segmentation.DomainStreamRequest,
		stream segmentation.DomainService_SubscribeServer) error
}

// DomainGetSomeError is the key that failed to read and how it failed.
// This error is user-facing and should read as such.
type DomainGetSomeError struct {
	Key   *segmentation.DomainKey
	Error error
}

// DomainGetSomeOverride allows for writing a "custom" GetSome implementation
// that is more efficient than the default (calling Get(...) in a loop).
//
// The implementor should attempt to send all responses into the channel resp.
// The implementor should close the channel resp when all responses have been sent.
// Any significant error should be returned.
// Any error returned will lead to a "code.Internal" error status on the request.
type DomainGetSomeOverride interface {
	GetSomeOverride(
		ctx context.Context,
		req *segmentation.DomainSomeRequest,
		resp chan<- *segmentation.DomainSomeResponse,
	) error
}

// DomainSubscribeBookends allows for custom behavior at the beginning and end of each
// Subscribe call. This is useful, for instance, if you need maintain some state that
// only lasts the duration of the call.
type DomainSubscribeBookends interface {
	// OnSubscribeStart is called at the beginning of Subscribe. It takes a pointer
	// to the context that was passed to Subscribe, allowing it to be overidden. E.g.,
	//
	// *ctx = context.WithValue(*ctx, ...)
	//
	// The Subscribe request is also passed to this method for additional context.
	OnSubscribeStart(ctx *context.Context, req *segmentation.DomainStreamRequest) *status.Status
	// OnSubscribeEnd is called just before Subscribe ends.
	OnSubscribeEnd(ctx context.Context, req *segmentation.DomainStreamRequest) error
}

// DomainConfigBase is an interface that provides the Aeris connection.
type DomainConfigBase interface {
	// Connection returns the connection being used to read from Aeris.
	// This connection is only used by the runner for subscriptions,
	// but should be readily available or constructible.
	Connection() *grpc.ClientConn
}

// DomainConfigMapper is an interface that declares where from Aeris to read data.
type DomainConfigMapper interface {

	// PathOf is given a request and is expected to return a valid Aeris path to the object.
	//
	// This result is used purely internally for KeyOf and Get. Only these methods needs
	// to interpret this path+keys, so the returned result can be an implementation detail.
	// Implementations are free to use or ignore the key array as necessary.
	//
	// If the path cannot be constructed, an error should be returned. This error will be logged
	// and an Internal error will be sent to the client.
	PathOf(context.Context, *segmentation.DomainKey) (key.Path, []key.Key,
		error)
	// KeyOf is given an Aeris path (generally from an update notif) and is expected to return a
	// valid DomainKey to return to the client.
	//
	// If the key struct cannot be constructed, an error should be returned.
	// This error will be logged and an Internal error will be sent to the client.
	KeyOf(context.Context, key.Path, key.Key) (*segmentation.DomainKey, error)

	// SubscribeRequests takes the stream request and returns information about 0 or
	// more Aeris subscriptions which should be initiated and run until either
	// completion or cancellation of the request context.
	//
	// This function should heavily consider optimizations of this request,
	// especially as it pertains to subscriptions. Examples:
	//
	//     - single filter + has key           -> subscribe to single path
	//     - many filters  + all have keys     -> subscribe to N paths (but not all)
	//     - many filters  + not all have keys -> subscribe to all (avoid dupes)
	//
	// This function is given the context from the request as well as the request
	// to the method which spawned this call. The passed in request should be
	// expected to be the {Resource}StreamRequest as defined in your proto.
	//
	// If the returned slice is empty, the runner will assume there is no work to
	// be done and the streaming handler will return, closing the stream to the client.
	//
	// All results of the subscription(s) are passed through Reader.FormatUpdate
	// before being sent to the client.
	SubscribeRequests(context.Context, *segmentation.DomainConfigStreamRequest) []rclient.SubscribeInfo
}

// DomainConfigAndTs is a struct that contains the DomainConfig value & time
type DomainConfigAndTs struct {
	Value *segmentation.DomainConfig
	Time  time.Time
}

// DomainConfigAndOperation holds a DomainConfig and subscriptions.Operation.
type DomainConfigAndOperation struct {
	Value     *segmentation.DomainConfig
	Operation subscriptions.Operation
}

// DomainConfigReader is an interface which abstracts how your resource can be read from
// Aeris (which may differ drastically from how it writes).
type DomainConfigReader interface {
	// Because the hook runner only uses the Reader and Writer interface,
	// the type implementing this interface must also implement Mapper.
	DomainConfigMapper

	// AllowGetAll allows the rpc to expose the GetAll method, while also being able to specify
	// that it is currently unsupported (but may be at a later date) and provide the relevant
	// response code for why.
	//
	// In practice, this should almost always return codes.OK, however, there may be concerns over
	// the scale (or technical unfeasability) of gathering the data.
	//
	// If this function does return any error code, the rationale and behavior should be properly
	// documented for clients so they do no expect results from this method.
	AllowGetAll(context.Context) codes.Code

	// ValidSubscribe is given the DomainConfigStreamRequest received by the server and is expected
	// to verify that this operation is valid/allowed. Validation may include (but not limited to):
	//
	//     - are subscriptions allowed on this resource with/without filters
	//     - do filters contain disallowed fields
	//     - do time-range parameters make sense
	//
	// The message contained in a returned error will be sent to the client. This message
	// should sufficiently explain how the user can correct the issue, but not so verbose
	// as to expose implementation and/or internal details. Logging should be used for
	// more informative errors.
	ValidateSubscribe(context.Context, *segmentation.DomainConfigStreamRequest) *status.Status

	// FormatUpdate is called on each notification in a notification batch
	// returned by a subscription and returns a series of DomainConfig and operation
	// to be tested by the filter. The operation should never be set to
	// INITIAL_SYNC_COMPLETE as this operation is handled by the calling code. If
	// the operation is not set (i.e. it's UNSPECIFIED), then the calling code
	// sets it to either INITIAL or UPDATED depending on the subscription phase.
	// This phase is indicated by the first parameter; if true, it indicates that
	// the update is initial state and, if false, that it is non-initial state.
	//
	// It is up to the implementor to extract the model's key(s) from the notification.
	// Similarly, you must call .Updates() to get the modified fields and you
	// may also optionally inspect the timestamp if re-ordering is required.
	//
	// Deletes contained in this notification should be ignored as they are
	// passed to FormatDelete rather than this method.
	//
	// To drop a notification, return an empty slice.
	// Returned errors will be logged, but will not terminate the subscription.
	FormatUpdate(context.Context, bool, types.Notification) ([]DomainConfigAndOperation, error)

	// OnInitialSyncComplete is called just before a subscription indicates to
	// the client that the initial state has all been sent. This method gives
	// the implementor a chance to send any additional resources that it may
	// have been holding onto.
	OnInitialSyncComplete(context.Context) ([]*DomainConfigAndTs, error)

	// Get fetches a single entity from Aeris.
	// The given Path is the result of calling MakePath. The Options struct is derived
	// from the request by the hooks-runner and can (generally) be passed to the Aeris client.
	// Implementors are allowed to modify the options so long as they respect what was given
	// in the request.
	//
	// Returning nil indicates that the resource does not exist and NotFound will be
	// returned to the client.
	//
	// The returned timestamp must be either (in order of precedence):
	//
	//     1. the timestamp received within the notification for this read (if applicable)
	//     2. the End timestamp within client.Options (if set)
	//     3. the time immediately after the read operation returned
	//
	// This convention allows the returned timestamp to always return a
	// relevant entry when the returned time is used as an End parameter to a later fetch.
	//
	// The message contained in a returned error will be sent to the client. This message
	// should sufficiently explain how the user can correct the issue, but not so verbose
	// as to expose implementation and/or internal details. Logging should be used for
	// more informative errors.
	Get(
		context.Context,
		key.Path, []key.Key,
		*api.Options,
	) (*segmentation.DomainConfig, time.Time, *status.Status)

	// GetAll feeds all or a subset (based on the request filters) of the instances
	// of DomainConfig in Aeris to the client via the channel passed into the method.
	//
	// The client.Options argument is the result of converting the arista.time.TimeRange
	// in the request into options usable with Aeris clients.
	//
	// It is the responsibility of the implementer to close the channel passed to
	// GetAll before returning.
	//
	// Returning without sending on the channel results in no stream messages sent to the client.
	GetAll(context.Context, *segmentation.DomainConfigStreamRequest, *api.Options,
		chan<- DomainConfigAndTs) *status.Status
	// Subscribe hands control of the entire subscription over to an individual service, allowing
	// the service to do whatever it wants with the Subscribe() API, instead of the Aeris-specific
	// way most resource APIs deal with things. It will eventually be replaced with a suite of
	// gNMI-specific methods that can be called in a similar way to Aeris-specific interface methods
	Subscribe(ctx context.Context, req *segmentation.DomainConfigStreamRequest,
		stream segmentation.DomainConfigService_SubscribeServer) error
}

// DomainConfigGetSomeError is the key that failed to read and how it failed.
// This error is user-facing and should read as such.
type DomainConfigGetSomeError struct {
	Key   *segmentation.DomainKey
	Error error
}

// DomainConfigGetSomeOverride allows for writing a "custom" GetSome implementation
// that is more efficient than the default (calling Get(...) in a loop).
//
// The implementor should attempt to send all responses into the channel resp.
// The implementor should close the channel resp when all responses have been sent.
// Any significant error should be returned.
// Any error returned will lead to a "code.Internal" error status on the request.
type DomainConfigGetSomeOverride interface {
	GetSomeOverride(
		ctx context.Context,
		req *segmentation.DomainConfigSomeRequest,
		resp chan<- *segmentation.DomainConfigSomeResponse,
	) error
}

// DomainConfigSubscribeBookends allows for custom behavior at the beginning and end of each
// Subscribe call. This is useful, for instance, if you need maintain some state that
// only lasts the duration of the call.
type DomainConfigSubscribeBookends interface {
	// OnSubscribeStart is called at the beginning of Subscribe. It takes a pointer
	// to the context that was passed to Subscribe, allowing it to be overidden. E.g.,
	//
	// *ctx = context.WithValue(*ctx, ...)
	//
	// The Subscribe request is also passed to this method for additional context.
	OnSubscribeStart(ctx *context.Context, req *segmentation.DomainConfigStreamRequest) *status.Status
	// OnSubscribeEnd is called just before Subscribe ends.
	OnSubscribeEnd(ctx context.Context, req *segmentation.DomainConfigStreamRequest) error
}

// DeletedDomainConfigAndTs is a struct that holds the delete error TypeAndError,
// DomainKey and time
type DeletedDomainConfigAndTs struct {
	TypeAndError rclient.DeletionError
	Key          *segmentation.DomainKey
	Time         time.Time
}

type DomainConfigAllDeleter interface {
	// DeleteAllHandler is expected to delete every key in a resource collection.
	// When DeleteAllHandler is implemented, rpc DeleteAll will call DeleteAllHandler.
	// If all keys are deleted successfully, the service will close the RPC gracefully.
	// The returned timestamp will have the timestamp used when publishing to Aeris.
	//
	// It is the responsibility of the implementer to close the channel passed to
	// DeleteAllHandler before returning.
	//
	// If a service begins deleting data from storage and some keys are deleted but
	// others fail, it should return over a channel the DeleteError for the keys it fails
	// to delete in the DeleteResponse (in DeletedDomainConfigAndTs).
	// If a service runs into any error before deleting any key, it will return
	// a single response with an appropriate DeleteError and error message,
	// without setting any key, and close the RPC.
	DeleteAllHandler(context.Context,
		*segmentation.DomainConfigDeleteAllRequest, chan<- DeletedDomainConfigAndTs) *status.Status
}

type DomainConfigPathDeleter interface {
	// GetDeletePaths specifies a set of paths to delete and a dataset to delete from.
	// Wildcards are permitted.
	//
	// If all keys from the paths are deleted successfully,
	// the service will close the RPC gracefully.
	//
	// If a service begins deleting data from storage and some keys are deleted but others
	// fail, it should return the keys it fails to delete in the DeleteResponse
	//
	// If a service runs into any error before deleting any key, it will
	// return a single response with an appropriate DeleteError and error message,
	// without setting any key, and close the RPC.
	GetDeletePaths(context.Context) ([]key.Path, pb.Dataset, error)
}

// DomainConfigSetSomeError is the key that failed to write and how it failed.
// This error is user-facing and should read as such.
type DomainConfigSetSomeError struct {
	Key   *segmentation.DomainKey
	Error error
}

// DomainConfigSetSomeOverride allows for writing a "custom" SetSome implementation
// that is more efficient than the default (calling Write(...) in a loop).
//
// The implementor should attempt write all values into storage and return all errors that occur.
// The returned errors will be sent to the client so they should be user-approriate.
// Any errors returned will lead to a "code.Internal" error status on the request.
//
// When overriding, values __will not__ have been passed to ValidateWrite so this must be
// taken care of. While hooks-runner is capable of calling it, we'd have to track values
// which have and have not passed validation. This causes unnecessary memory usage for something
// that could just be returned as an error from this function.
type DomainConfigSetSomeOverride interface {
	SetSomeOverride(ctx context.Context, req *segmentation.DomainConfigSetSomeRequest) []DomainConfigSetSomeError
}

// DomainConfigDeleteSomeError is the key that failed to delete and how it failed.
// DomainConfigDeleteSomeError is only sent when there is an error.
// This error is user-facing and should read as such.
type DomainConfigDeleteSomeError struct {
	Key   *segmentation.DomainKey
	Error error
}

// DomainConfigDeleteSomeOverride allows for writing a "custom" DeleteSome implementation
// that is more efficient than the default (calling Delete(...) in a loop).
//
// The implementor should attempt delete all values from storage and return all errors that occur.
// The returned errors will be sent to the client so they should be user-approriate.
// Any errors returned will lead to a "code.Internal" error status on the request.
type DomainConfigDeleteSomeOverride interface {
	DeleteSomeOverride(ctx context.Context, req *segmentation.DomainConfigDeleteSomeRequest) []DomainConfigDeleteSomeError
}

// DomainConfigWriter is an abstraction over how your service will write resources into Aeris.
// All validation will be done before the call to Write or Delete, so those methods can
// simply implement the required action.
type DomainConfigWriter interface {
	// ValidateWrite is given the DomainConfig within a DomainConfigWriteRequest and is expected to
	// return any errors with the request. Validation may include (but not limited to):
	//
	//     - checking all required fields are given
	//     - provided fields are valid (format, contents, etc.)
	//     - if server-generated fields are given, handle as update
	//         - should probably only be allowed as part of the Key
	//         - verify validity/existence/etc to avoid accidental overwrites
	//
	// The message contained in a returned error will be sent to the client. This message
	// should sufficiently explain how the user can correct the issue, but not so verbose
	// as to expose implementation and/or internal details. Logging should be used for
	// more informative errors.
	ValidateWrite(context.Context, *segmentation.DomainConfig) error

	// Write is expected to write the given DomainConfig into Aeris (and do any data
	// transformations required to match Aeris' schema before writing).
	//
	// The entity from the request is passed as a pointer so that any modifications made to
	// it are echoed back to the client. This is ideal for server-generated values. Simply
	// set the values on the entity before converting to Aeris-form.
	//
	// The returned timestamp must be either the timestamp associated with the notification
	// sent to Aeris for this write (if applicable) or the time immediately after the write
	// operation returned. This convention allows the returned timestamp to always return a
	// valid entry when the returned time is used as an End parameter to a later fetch.
	//
	// The message contained in a returned error will be sent to the client. This message
	// should sufficiently explain how the user can correct the issue, but not so verbose
	// as to expose implementation and/or internal details. Logging should be used for
	// more informative errors.
	Write(context.Context, *segmentation.DomainConfig) (time.Time, *status.Status)
	// Delete is expected to delete the entity within Aeris identified by the given key.
	//
	// The returned timestamp should be the same as the timestamp used when publishing
	// to Aeris. This allows clients to have a minimal timestamp for which the deleted
	// entity will not exist in future queries.
	//
	// The message contained in a returned error will be sent to the client. This message
	// should sufficiently explain how the user can correct the issue, but not so verbose
	// as to expose implementation and/or internal details. Logging should be used for
	// more informative errors.
	Delete(context.Context, *segmentation.DomainKey) (time.Time, *status.Status)
}

// DomainIPPrefixConfigBase is an interface that provides the Aeris connection.
type DomainIPPrefixConfigBase interface {
	// Connection returns the connection being used to read from Aeris.
	// This connection is only used by the runner for subscriptions,
	// but should be readily available or constructible.
	Connection() *grpc.ClientConn
}

// DomainIPPrefixConfigMapper is an interface that declares where from Aeris to read data.
type DomainIPPrefixConfigMapper interface {

	// PathOf is given a request and is expected to return a valid Aeris path to the object.
	//
	// This result is used purely internally for KeyOf and Get. Only these methods needs
	// to interpret this path+keys, so the returned result can be an implementation detail.
	// Implementations are free to use or ignore the key array as necessary.
	//
	// If the path cannot be constructed, an error should be returned. This error will be logged
	// and an Internal error will be sent to the client.
	PathOf(context.Context, *segmentation.DomainIPPrefixKey) (key.Path, []key.Key,
		error)
	// KeyOf is given an Aeris path (generally from an update notif) and is expected to return a
	// valid DomainIPPrefixKey to return to the client.
	//
	// If the key struct cannot be constructed, an error should be returned.
	// This error will be logged and an Internal error will be sent to the client.
	KeyOf(context.Context, key.Path, key.Key) (*segmentation.DomainIPPrefixKey, error)

	// SubscribeRequests takes the stream request and returns information about 0 or
	// more Aeris subscriptions which should be initiated and run until either
	// completion or cancellation of the request context.
	//
	// This function should heavily consider optimizations of this request,
	// especially as it pertains to subscriptions. Examples:
	//
	//     - single filter + has key           -> subscribe to single path
	//     - many filters  + all have keys     -> subscribe to N paths (but not all)
	//     - many filters  + not all have keys -> subscribe to all (avoid dupes)
	//
	// This function is given the context from the request as well as the request
	// to the method which spawned this call. The passed in request should be
	// expected to be the {Resource}StreamRequest as defined in your proto.
	//
	// If the returned slice is empty, the runner will assume there is no work to
	// be done and the streaming handler will return, closing the stream to the client.
	//
	// All results of the subscription(s) are passed through Reader.FormatUpdate
	// before being sent to the client.
	SubscribeRequests(context.Context, *segmentation.DomainIPPrefixConfigStreamRequest) []rclient.SubscribeInfo
}

// DomainIPPrefixConfigAndTs is a struct that contains the DomainIPPrefixConfig value & time
type DomainIPPrefixConfigAndTs struct {
	Value *segmentation.DomainIPPrefixConfig
	Time  time.Time
}

// DomainIPPrefixConfigAndOperation holds a DomainIPPrefixConfig and subscriptions.Operation.
type DomainIPPrefixConfigAndOperation struct {
	Value     *segmentation.DomainIPPrefixConfig
	Operation subscriptions.Operation
}

// DomainIPPrefixConfigReader is an interface which abstracts how your resource can be read from
// Aeris (which may differ drastically from how it writes).
type DomainIPPrefixConfigReader interface {
	// Because the hook runner only uses the Reader and Writer interface,
	// the type implementing this interface must also implement Mapper.
	DomainIPPrefixConfigMapper

	// AllowGetAll allows the rpc to expose the GetAll method, while also being able to specify
	// that it is currently unsupported (but may be at a later date) and provide the relevant
	// response code for why.
	//
	// In practice, this should almost always return codes.OK, however, there may be concerns over
	// the scale (or technical unfeasability) of gathering the data.
	//
	// If this function does return any error code, the rationale and behavior should be properly
	// documented for clients so they do no expect results from this method.
	AllowGetAll(context.Context) codes.Code

	// ValidSubscribe is given the DomainIPPrefixConfigStreamRequest received by the server and is expected
	// to verify that this operation is valid/allowed. Validation may include (but not limited to):
	//
	//     - are subscriptions allowed on this resource with/without filters
	//     - do filters contain disallowed fields
	//     - do time-range parameters make sense
	//
	// The message contained in a returned error will be sent to the client. This message
	// should sufficiently explain how the user can correct the issue, but not so verbose
	// as to expose implementation and/or internal details. Logging should be used for
	// more informative errors.
	ValidateSubscribe(context.Context, *segmentation.DomainIPPrefixConfigStreamRequest) *status.Status

	// FormatUpdate is called on each notification in a notification batch
	// returned by a subscription and returns a series of DomainIPPrefixConfig and operation
	// to be tested by the filter. The operation should never be set to
	// INITIAL_SYNC_COMPLETE as this operation is handled by the calling code. If
	// the operation is not set (i.e. it's UNSPECIFIED), then the calling code
	// sets it to either INITIAL or UPDATED depending on the subscription phase.
	// This phase is indicated by the first parameter; if true, it indicates that
	// the update is initial state and, if false, that it is non-initial state.
	//
	// It is up to the implementor to extract the model's key(s) from the notification.
	// Similarly, you must call .Updates() to get the modified fields and you
	// may also optionally inspect the timestamp if re-ordering is required.
	//
	// Deletes contained in this notification should be ignored as they are
	// passed to FormatDelete rather than this method.
	//
	// To drop a notification, return an empty slice.
	// Returned errors will be logged, but will not terminate the subscription.
	FormatUpdate(context.Context, bool, types.Notification) ([]DomainIPPrefixConfigAndOperation, error)

	// OnInitialSyncComplete is called just before a subscription indicates to
	// the client that the initial state has all been sent. This method gives
	// the implementor a chance to send any additional resources that it may
	// have been holding onto.
	OnInitialSyncComplete(context.Context) ([]*DomainIPPrefixConfigAndTs, error)

	// Get fetches a single entity from Aeris.
	// The given Path is the result of calling MakePath. The Options struct is derived
	// from the request by the hooks-runner and can (generally) be passed to the Aeris client.
	// Implementors are allowed to modify the options so long as they respect what was given
	// in the request.
	//
	// Returning nil indicates that the resource does not exist and NotFound will be
	// returned to the client.
	//
	// The returned timestamp must be either (in order of precedence):
	//
	//     1. the timestamp received within the notification for this read (if applicable)
	//     2. the End timestamp within client.Options (if set)
	//     3. the time immediately after the read operation returned
	//
	// This convention allows the returned timestamp to always return a
	// relevant entry when the returned time is used as an End parameter to a later fetch.
	//
	// The message contained in a returned error will be sent to the client. This message
	// should sufficiently explain how the user can correct the issue, but not so verbose
	// as to expose implementation and/or internal details. Logging should be used for
	// more informative errors.
	Get(
		context.Context,
		key.Path, []key.Key,
		*api.Options,
	) (*segmentation.DomainIPPrefixConfig, time.Time, *status.Status)

	// GetAll feeds all or a subset (based on the request filters) of the instances
	// of DomainIPPrefixConfig in Aeris to the client via the channel passed into the method.
	//
	// The client.Options argument is the result of converting the arista.time.TimeRange
	// in the request into options usable with Aeris clients.
	//
	// It is the responsibility of the implementer to close the channel passed to
	// GetAll before returning.
	//
	// Returning without sending on the channel results in no stream messages sent to the client.
	GetAll(context.Context, *segmentation.DomainIPPrefixConfigStreamRequest, *api.Options,
		chan<- DomainIPPrefixConfigAndTs) *status.Status
	// Subscribe hands control of the entire subscription over to an individual service, allowing
	// the service to do whatever it wants with the Subscribe() API, instead of the Aeris-specific
	// way most resource APIs deal with things. It will eventually be replaced with a suite of
	// gNMI-specific methods that can be called in a similar way to Aeris-specific interface methods
	Subscribe(ctx context.Context, req *segmentation.DomainIPPrefixConfigStreamRequest,
		stream segmentation.DomainIPPrefixConfigService_SubscribeServer) error
}

// DomainIPPrefixConfigGetSomeError is the key that failed to read and how it failed.
// This error is user-facing and should read as such.
type DomainIPPrefixConfigGetSomeError struct {
	Key   *segmentation.DomainIPPrefixKey
	Error error
}

// DomainIPPrefixConfigGetSomeOverride allows for writing a "custom" GetSome implementation
// that is more efficient than the default (calling Get(...) in a loop).
//
// The implementor should attempt to send all responses into the channel resp.
// The implementor should close the channel resp when all responses have been sent.
// Any significant error should be returned.
// Any error returned will lead to a "code.Internal" error status on the request.
type DomainIPPrefixConfigGetSomeOverride interface {
	GetSomeOverride(
		ctx context.Context,
		req *segmentation.DomainIPPrefixConfigSomeRequest,
		resp chan<- *segmentation.DomainIPPrefixConfigSomeResponse,
	) error
}

// DomainIPPrefixConfigSubscribeBookends allows for custom behavior at the beginning and end of each
// Subscribe call. This is useful, for instance, if you need maintain some state that
// only lasts the duration of the call.
type DomainIPPrefixConfigSubscribeBookends interface {
	// OnSubscribeStart is called at the beginning of Subscribe. It takes a pointer
	// to the context that was passed to Subscribe, allowing it to be overidden. E.g.,
	//
	// *ctx = context.WithValue(*ctx, ...)
	//
	// The Subscribe request is also passed to this method for additional context.
	OnSubscribeStart(ctx *context.Context, req *segmentation.DomainIPPrefixConfigStreamRequest) *status.Status
	// OnSubscribeEnd is called just before Subscribe ends.
	OnSubscribeEnd(ctx context.Context, req *segmentation.DomainIPPrefixConfigStreamRequest) error
}

// DeletedDomainIPPrefixConfigAndTs is a struct that holds the delete error TypeAndError,
// DomainIPPrefixKey and time
type DeletedDomainIPPrefixConfigAndTs struct {
	TypeAndError rclient.DeletionError
	Key          *segmentation.DomainIPPrefixKey
	Time         time.Time
}

type DomainIPPrefixConfigAllDeleter interface {
	// DeleteAllHandler is expected to delete every key in a resource collection.
	// When DeleteAllHandler is implemented, rpc DeleteAll will call DeleteAllHandler.
	// If all keys are deleted successfully, the service will close the RPC gracefully.
	// The returned timestamp will have the timestamp used when publishing to Aeris.
	//
	// It is the responsibility of the implementer to close the channel passed to
	// DeleteAllHandler before returning.
	//
	// If a service begins deleting data from storage and some keys are deleted but
	// others fail, it should return over a channel the DeleteError for the keys it fails
	// to delete in the DeleteResponse (in DeletedDomainIPPrefixConfigAndTs).
	// If a service runs into any error before deleting any key, it will return
	// a single response with an appropriate DeleteError and error message,
	// without setting any key, and close the RPC.
	DeleteAllHandler(context.Context,
		*segmentation.DomainIPPrefixConfigDeleteAllRequest, chan<- DeletedDomainIPPrefixConfigAndTs) *status.Status
}

type DomainIPPrefixConfigPathDeleter interface {
	// GetDeletePaths specifies a set of paths to delete and a dataset to delete from.
	// Wildcards are permitted.
	//
	// If all keys from the paths are deleted successfully,
	// the service will close the RPC gracefully.
	//
	// If a service begins deleting data from storage and some keys are deleted but others
	// fail, it should return the keys it fails to delete in the DeleteResponse
	//
	// If a service runs into any error before deleting any key, it will
	// return a single response with an appropriate DeleteError and error message,
	// without setting any key, and close the RPC.
	GetDeletePaths(context.Context) ([]key.Path, pb.Dataset, error)
}

// DomainIPPrefixConfigSetSomeError is the key that failed to write and how it failed.
// This error is user-facing and should read as such.
type DomainIPPrefixConfigSetSomeError struct {
	Key   *segmentation.DomainIPPrefixKey
	Error error
}

// DomainIPPrefixConfigSetSomeOverride allows for writing a "custom" SetSome implementation
// that is more efficient than the default (calling Write(...) in a loop).
//
// The implementor should attempt write all values into storage and return all errors that occur.
// The returned errors will be sent to the client so they should be user-approriate.
// Any errors returned will lead to a "code.Internal" error status on the request.
//
// When overriding, values __will not__ have been passed to ValidateWrite so this must be
// taken care of. While hooks-runner is capable of calling it, we'd have to track values
// which have and have not passed validation. This causes unnecessary memory usage for something
// that could just be returned as an error from this function.
type DomainIPPrefixConfigSetSomeOverride interface {
	SetSomeOverride(ctx context.Context, req *segmentation.DomainIPPrefixConfigSetSomeRequest) []DomainIPPrefixConfigSetSomeError
}

// DomainIPPrefixConfigDeleteSomeError is the key that failed to delete and how it failed.
// DomainIPPrefixConfigDeleteSomeError is only sent when there is an error.
// This error is user-facing and should read as such.
type DomainIPPrefixConfigDeleteSomeError struct {
	Key   *segmentation.DomainIPPrefixKey
	Error error
}

// DomainIPPrefixConfigDeleteSomeOverride allows for writing a "custom" DeleteSome implementation
// that is more efficient than the default (calling Delete(...) in a loop).
//
// The implementor should attempt delete all values from storage and return all errors that occur.
// The returned errors will be sent to the client so they should be user-approriate.
// Any errors returned will lead to a "code.Internal" error status on the request.
type DomainIPPrefixConfigDeleteSomeOverride interface {
	DeleteSomeOverride(ctx context.Context, req *segmentation.DomainIPPrefixConfigDeleteSomeRequest) []DomainIPPrefixConfigDeleteSomeError
}

// DomainIPPrefixConfigWriter is an abstraction over how your service will write resources into Aeris.
// All validation will be done before the call to Write or Delete, so those methods can
// simply implement the required action.
type DomainIPPrefixConfigWriter interface {
	// ValidateWrite is given the DomainIPPrefixConfig within a DomainIPPrefixConfigWriteRequest and is expected to
	// return any errors with the request. Validation may include (but not limited to):
	//
	//     - checking all required fields are given
	//     - provided fields are valid (format, contents, etc.)
	//     - if server-generated fields are given, handle as update
	//         - should probably only be allowed as part of the Key
	//         - verify validity/existence/etc to avoid accidental overwrites
	//
	// The message contained in a returned error will be sent to the client. This message
	// should sufficiently explain how the user can correct the issue, but not so verbose
	// as to expose implementation and/or internal details. Logging should be used for
	// more informative errors.
	ValidateWrite(context.Context, *segmentation.DomainIPPrefixConfig) error

	// Write is expected to write the given DomainIPPrefixConfig into Aeris (and do any data
	// transformations required to match Aeris' schema before writing).
	//
	// The entity from the request is passed as a pointer so that any modifications made to
	// it are echoed back to the client. This is ideal for server-generated values. Simply
	// set the values on the entity before converting to Aeris-form.
	//
	// The returned timestamp must be either the timestamp associated with the notification
	// sent to Aeris for this write (if applicable) or the time immediately after the write
	// operation returned. This convention allows the returned timestamp to always return a
	// valid entry when the returned time is used as an End parameter to a later fetch.
	//
	// The message contained in a returned error will be sent to the client. This message
	// should sufficiently explain how the user can correct the issue, but not so verbose
	// as to expose implementation and/or internal details. Logging should be used for
	// more informative errors.
	Write(context.Context, *segmentation.DomainIPPrefixConfig) (time.Time, *status.Status)
	// Delete is expected to delete the entity within Aeris identified by the given key.
	//
	// The returned timestamp should be the same as the timestamp used when publishing
	// to Aeris. This allows clients to have a minimal timestamp for which the deleted
	// entity will not exist in future queries.
	//
	// The message contained in a returned error will be sent to the client. This message
	// should sufficiently explain how the user can correct the issue, but not so verbose
	// as to expose implementation and/or internal details. Logging should be used for
	// more informative errors.
	Delete(context.Context, *segmentation.DomainIPPrefixKey) (time.Time, *status.Status)
}

// DomainSegmentConfigBase is an interface that provides the Aeris connection.
type DomainSegmentConfigBase interface {
	// Connection returns the connection being used to read from Aeris.
	// This connection is only used by the runner for subscriptions,
	// but should be readily available or constructible.
	Connection() *grpc.ClientConn
}

// DomainSegmentConfigMapper is an interface that declares where from Aeris to read data.
type DomainSegmentConfigMapper interface {

	// PathOf is given a request and is expected to return a valid Aeris path to the object.
	//
	// This result is used purely internally for KeyOf and Get. Only these methods needs
	// to interpret this path+keys, so the returned result can be an implementation detail.
	// Implementations are free to use or ignore the key array as necessary.
	//
	// If the path cannot be constructed, an error should be returned. This error will be logged
	// and an Internal error will be sent to the client.
	PathOf(context.Context, *segmentation.DomainSegmentKey) (key.Path, []key.Key,
		error)
	// KeyOf is given an Aeris path (generally from an update notif) and is expected to return a
	// valid DomainSegmentKey to return to the client.
	//
	// If the key struct cannot be constructed, an error should be returned.
	// This error will be logged and an Internal error will be sent to the client.
	KeyOf(context.Context, key.Path, key.Key) (*segmentation.DomainSegmentKey, error)

	// SubscribeRequests takes the stream request and returns information about 0 or
	// more Aeris subscriptions which should be initiated and run until either
	// completion or cancellation of the request context.
	//
	// This function should heavily consider optimizations of this request,
	// especially as it pertains to subscriptions. Examples:
	//
	//     - single filter + has key           -> subscribe to single path
	//     - many filters  + all have keys     -> subscribe to N paths (but not all)
	//     - many filters  + not all have keys -> subscribe to all (avoid dupes)
	//
	// This function is given the context from the request as well as the request
	// to the method which spawned this call. The passed in request should be
	// expected to be the {Resource}StreamRequest as defined in your proto.
	//
	// If the returned slice is empty, the runner will assume there is no work to
	// be done and the streaming handler will return, closing the stream to the client.
	//
	// All results of the subscription(s) are passed through Reader.FormatUpdate
	// before being sent to the client.
	SubscribeRequests(context.Context, *segmentation.DomainSegmentConfigStreamRequest) []rclient.SubscribeInfo
}

// DomainSegmentConfigAndTs is a struct that contains the DomainSegmentConfig value & time
type DomainSegmentConfigAndTs struct {
	Value *segmentation.DomainSegmentConfig
	Time  time.Time
}

// DomainSegmentConfigAndOperation holds a DomainSegmentConfig and subscriptions.Operation.
type DomainSegmentConfigAndOperation struct {
	Value     *segmentation.DomainSegmentConfig
	Operation subscriptions.Operation
}

// DomainSegmentConfigReader is an interface which abstracts how your resource can be read from
// Aeris (which may differ drastically from how it writes).
type DomainSegmentConfigReader interface {
	// Because the hook runner only uses the Reader and Writer interface,
	// the type implementing this interface must also implement Mapper.
	DomainSegmentConfigMapper

	// AllowGetAll allows the rpc to expose the GetAll method, while also being able to specify
	// that it is currently unsupported (but may be at a later date) and provide the relevant
	// response code for why.
	//
	// In practice, this should almost always return codes.OK, however, there may be concerns over
	// the scale (or technical unfeasability) of gathering the data.
	//
	// If this function does return any error code, the rationale and behavior should be properly
	// documented for clients so they do no expect results from this method.
	AllowGetAll(context.Context) codes.Code

	// ValidSubscribe is given the DomainSegmentConfigStreamRequest received by the server and is expected
	// to verify that this operation is valid/allowed. Validation may include (but not limited to):
	//
	//     - are subscriptions allowed on this resource with/without filters
	//     - do filters contain disallowed fields
	//     - do time-range parameters make sense
	//
	// The message contained in a returned error will be sent to the client. This message
	// should sufficiently explain how the user can correct the issue, but not so verbose
	// as to expose implementation and/or internal details. Logging should be used for
	// more informative errors.
	ValidateSubscribe(context.Context, *segmentation.DomainSegmentConfigStreamRequest) *status.Status

	// FormatUpdate is called on each notification in a notification batch
	// returned by a subscription and returns a series of DomainSegmentConfig and operation
	// to be tested by the filter. The operation should never be set to
	// INITIAL_SYNC_COMPLETE as this operation is handled by the calling code. If
	// the operation is not set (i.e. it's UNSPECIFIED), then the calling code
	// sets it to either INITIAL or UPDATED depending on the subscription phase.
	// This phase is indicated by the first parameter; if true, it indicates that
	// the update is initial state and, if false, that it is non-initial state.
	//
	// It is up to the implementor to extract the model's key(s) from the notification.
	// Similarly, you must call .Updates() to get the modified fields and you
	// may also optionally inspect the timestamp if re-ordering is required.
	//
	// Deletes contained in this notification should be ignored as they are
	// passed to FormatDelete rather than this method.
	//
	// To drop a notification, return an empty slice.
	// Returned errors will be logged, but will not terminate the subscription.
	FormatUpdate(context.Context, bool, types.Notification) ([]DomainSegmentConfigAndOperation, error)

	// OnInitialSyncComplete is called just before a subscription indicates to
	// the client that the initial state has all been sent. This method gives
	// the implementor a chance to send any additional resources that it may
	// have been holding onto.
	OnInitialSyncComplete(context.Context) ([]*DomainSegmentConfigAndTs, error)

	// Get fetches a single entity from Aeris.
	// The given Path is the result of calling MakePath. The Options struct is derived
	// from the request by the hooks-runner and can (generally) be passed to the Aeris client.
	// Implementors are allowed to modify the options so long as they respect what was given
	// in the request.
	//
	// Returning nil indicates that the resource does not exist and NotFound will be
	// returned to the client.
	//
	// The returned timestamp must be either (in order of precedence):
	//
	//     1. the timestamp received within the notification for this read (if applicable)
	//     2. the End timestamp within client.Options (if set)
	//     3. the time immediately after the read operation returned
	//
	// This convention allows the returned timestamp to always return a
	// relevant entry when the returned time is used as an End parameter to a later fetch.
	//
	// The message contained in a returned error will be sent to the client. This message
	// should sufficiently explain how the user can correct the issue, but not so verbose
	// as to expose implementation and/or internal details. Logging should be used for
	// more informative errors.
	Get(
		context.Context,
		key.Path, []key.Key,
		*api.Options,
	) (*segmentation.DomainSegmentConfig, time.Time, *status.Status)

	// GetAll feeds all or a subset (based on the request filters) of the instances
	// of DomainSegmentConfig in Aeris to the client via the channel passed into the method.
	//
	// The client.Options argument is the result of converting the arista.time.TimeRange
	// in the request into options usable with Aeris clients.
	//
	// It is the responsibility of the implementer to close the channel passed to
	// GetAll before returning.
	//
	// Returning without sending on the channel results in no stream messages sent to the client.
	GetAll(context.Context, *segmentation.DomainSegmentConfigStreamRequest, *api.Options,
		chan<- DomainSegmentConfigAndTs) *status.Status
	// Subscribe hands control of the entire subscription over to an individual service, allowing
	// the service to do whatever it wants with the Subscribe() API, instead of the Aeris-specific
	// way most resource APIs deal with things. It will eventually be replaced with a suite of
	// gNMI-specific methods that can be called in a similar way to Aeris-specific interface methods
	Subscribe(ctx context.Context, req *segmentation.DomainSegmentConfigStreamRequest,
		stream segmentation.DomainSegmentConfigService_SubscribeServer) error
}

// DomainSegmentConfigGetSomeError is the key that failed to read and how it failed.
// This error is user-facing and should read as such.
type DomainSegmentConfigGetSomeError struct {
	Key   *segmentation.DomainSegmentKey
	Error error
}

// DomainSegmentConfigGetSomeOverride allows for writing a "custom" GetSome implementation
// that is more efficient than the default (calling Get(...) in a loop).
//
// The implementor should attempt to send all responses into the channel resp.
// The implementor should close the channel resp when all responses have been sent.
// Any significant error should be returned.
// Any error returned will lead to a "code.Internal" error status on the request.
type DomainSegmentConfigGetSomeOverride interface {
	GetSomeOverride(
		ctx context.Context,
		req *segmentation.DomainSegmentConfigSomeRequest,
		resp chan<- *segmentation.DomainSegmentConfigSomeResponse,
	) error
}

// DomainSegmentConfigSubscribeBookends allows for custom behavior at the beginning and end of each
// Subscribe call. This is useful, for instance, if you need maintain some state that
// only lasts the duration of the call.
type DomainSegmentConfigSubscribeBookends interface {
	// OnSubscribeStart is called at the beginning of Subscribe. It takes a pointer
	// to the context that was passed to Subscribe, allowing it to be overidden. E.g.,
	//
	// *ctx = context.WithValue(*ctx, ...)
	//
	// The Subscribe request is also passed to this method for additional context.
	OnSubscribeStart(ctx *context.Context, req *segmentation.DomainSegmentConfigStreamRequest) *status.Status
	// OnSubscribeEnd is called just before Subscribe ends.
	OnSubscribeEnd(ctx context.Context, req *segmentation.DomainSegmentConfigStreamRequest) error
}

// DeletedDomainSegmentConfigAndTs is a struct that holds the delete error TypeAndError,
// DomainSegmentKey and time
type DeletedDomainSegmentConfigAndTs struct {
	TypeAndError rclient.DeletionError
	Key          *segmentation.DomainSegmentKey
	Time         time.Time
}

type DomainSegmentConfigAllDeleter interface {
	// DeleteAllHandler is expected to delete every key in a resource collection.
	// When DeleteAllHandler is implemented, rpc DeleteAll will call DeleteAllHandler.
	// If all keys are deleted successfully, the service will close the RPC gracefully.
	// The returned timestamp will have the timestamp used when publishing to Aeris.
	//
	// It is the responsibility of the implementer to close the channel passed to
	// DeleteAllHandler before returning.
	//
	// If a service begins deleting data from storage and some keys are deleted but
	// others fail, it should return over a channel the DeleteError for the keys it fails
	// to delete in the DeleteResponse (in DeletedDomainSegmentConfigAndTs).
	// If a service runs into any error before deleting any key, it will return
	// a single response with an appropriate DeleteError and error message,
	// without setting any key, and close the RPC.
	DeleteAllHandler(context.Context,
		*segmentation.DomainSegmentConfigDeleteAllRequest, chan<- DeletedDomainSegmentConfigAndTs) *status.Status
}

type DomainSegmentConfigPathDeleter interface {
	// GetDeletePaths specifies a set of paths to delete and a dataset to delete from.
	// Wildcards are permitted.
	//
	// If all keys from the paths are deleted successfully,
	// the service will close the RPC gracefully.
	//
	// If a service begins deleting data from storage and some keys are deleted but others
	// fail, it should return the keys it fails to delete in the DeleteResponse
	//
	// If a service runs into any error before deleting any key, it will
	// return a single response with an appropriate DeleteError and error message,
	// without setting any key, and close the RPC.
	GetDeletePaths(context.Context) ([]key.Path, pb.Dataset, error)
}

// DomainSegmentConfigSetSomeError is the key that failed to write and how it failed.
// This error is user-facing and should read as such.
type DomainSegmentConfigSetSomeError struct {
	Key   *segmentation.DomainSegmentKey
	Error error
}

// DomainSegmentConfigSetSomeOverride allows for writing a "custom" SetSome implementation
// that is more efficient than the default (calling Write(...) in a loop).
//
// The implementor should attempt write all values into storage and return all errors that occur.
// The returned errors will be sent to the client so they should be user-approriate.
// Any errors returned will lead to a "code.Internal" error status on the request.
//
// When overriding, values __will not__ have been passed to ValidateWrite so this must be
// taken care of. While hooks-runner is capable of calling it, we'd have to track values
// which have and have not passed validation. This causes unnecessary memory usage for something
// that could just be returned as an error from this function.
type DomainSegmentConfigSetSomeOverride interface {
	SetSomeOverride(ctx context.Context, req *segmentation.DomainSegmentConfigSetSomeRequest) []DomainSegmentConfigSetSomeError
}

// DomainSegmentConfigDeleteSomeError is the key that failed to delete and how it failed.
// DomainSegmentConfigDeleteSomeError is only sent when there is an error.
// This error is user-facing and should read as such.
type DomainSegmentConfigDeleteSomeError struct {
	Key   *segmentation.DomainSegmentKey
	Error error
}

// DomainSegmentConfigDeleteSomeOverride allows for writing a "custom" DeleteSome implementation
// that is more efficient than the default (calling Delete(...) in a loop).
//
// The implementor should attempt delete all values from storage and return all errors that occur.
// The returned errors will be sent to the client so they should be user-approriate.
// Any errors returned will lead to a "code.Internal" error status on the request.
type DomainSegmentConfigDeleteSomeOverride interface {
	DeleteSomeOverride(ctx context.Context, req *segmentation.DomainSegmentConfigDeleteSomeRequest) []DomainSegmentConfigDeleteSomeError
}

// DomainSegmentConfigWriter is an abstraction over how your service will write resources into Aeris.
// All validation will be done before the call to Write or Delete, so those methods can
// simply implement the required action.
type DomainSegmentConfigWriter interface {
	// ValidateWrite is given the DomainSegmentConfig within a DomainSegmentConfigWriteRequest and is expected to
	// return any errors with the request. Validation may include (but not limited to):
	//
	//     - checking all required fields are given
	//     - provided fields are valid (format, contents, etc.)
	//     - if server-generated fields are given, handle as update
	//         - should probably only be allowed as part of the Key
	//         - verify validity/existence/etc to avoid accidental overwrites
	//
	// The message contained in a returned error will be sent to the client. This message
	// should sufficiently explain how the user can correct the issue, but not so verbose
	// as to expose implementation and/or internal details. Logging should be used for
	// more informative errors.
	ValidateWrite(context.Context, *segmentation.DomainSegmentConfig) error

	// Write is expected to write the given DomainSegmentConfig into Aeris (and do any data
	// transformations required to match Aeris' schema before writing).
	//
	// The entity from the request is passed as a pointer so that any modifications made to
	// it are echoed back to the client. This is ideal for server-generated values. Simply
	// set the values on the entity before converting to Aeris-form.
	//
	// The returned timestamp must be either the timestamp associated with the notification
	// sent to Aeris for this write (if applicable) or the time immediately after the write
	// operation returned. This convention allows the returned timestamp to always return a
	// valid entry when the returned time is used as an End parameter to a later fetch.
	//
	// The message contained in a returned error will be sent to the client. This message
	// should sufficiently explain how the user can correct the issue, but not so verbose
	// as to expose implementation and/or internal details. Logging should be used for
	// more informative errors.
	Write(context.Context, *segmentation.DomainSegmentConfig) (time.Time, *status.Status)
	// Delete is expected to delete the entity within Aeris identified by the given key.
	//
	// The returned timestamp should be the same as the timestamp used when publishing
	// to Aeris. This allows clients to have a minimal timestamp for which the deleted
	// entity will not exist in future queries.
	//
	// The message contained in a returned error will be sent to the client. This message
	// should sufficiently explain how the user can correct the issue, but not so verbose
	// as to expose implementation and/or internal details. Logging should be used for
	// more informative errors.
	Delete(context.Context, *segmentation.DomainSegmentKey) (time.Time, *status.Status)
}

// DomainSegmentPolicyBase is an interface that provides the Aeris connection.
type DomainSegmentPolicyBase interface {
	// Connection returns the connection being used to read from Aeris.
	// This connection is only used by the runner for subscriptions,
	// but should be readily available or constructible.
	Connection() *grpc.ClientConn
}

// DomainSegmentPolicyMapper is an interface that declares where from Aeris to read data.
type DomainSegmentPolicyMapper interface {

	// PathOf is given a request and is expected to return a valid Aeris path to the object.
	//
	// This result is used purely internally for KeyOf and Get. Only these methods needs
	// to interpret this path+keys, so the returned result can be an implementation detail.
	// Implementations are free to use or ignore the key array as necessary.
	//
	// If the path cannot be constructed, an error should be returned. This error will be logged
	// and an Internal error will be sent to the client.
	PathOf(context.Context, *segmentation.DomainSegmentPolicyKey) (key.Path, []key.Key,
		error)
	// KeyOf is given an Aeris path (generally from an update notif) and is expected to return a
	// valid DomainSegmentPolicyKey to return to the client.
	//
	// If the key struct cannot be constructed, an error should be returned.
	// This error will be logged and an Internal error will be sent to the client.
	KeyOf(context.Context, key.Path, key.Key) (*segmentation.DomainSegmentPolicyKey, error)

	// SubscribeRequests takes the stream request and returns information about 0 or
	// more Aeris subscriptions which should be initiated and run until either
	// completion or cancellation of the request context.
	//
	// This function should heavily consider optimizations of this request,
	// especially as it pertains to subscriptions. Examples:
	//
	//     - single filter + has key           -> subscribe to single path
	//     - many filters  + all have keys     -> subscribe to N paths (but not all)
	//     - many filters  + not all have keys -> subscribe to all (avoid dupes)
	//
	// This function is given the context from the request as well as the request
	// to the method which spawned this call. The passed in request should be
	// expected to be the {Resource}StreamRequest as defined in your proto.
	//
	// If the returned slice is empty, the runner will assume there is no work to
	// be done and the streaming handler will return, closing the stream to the client.
	//
	// All results of the subscription(s) are passed through Reader.FormatUpdate
	// before being sent to the client.
	SubscribeRequests(context.Context, *segmentation.DomainSegmentPolicyStreamRequest) []rclient.SubscribeInfo
}

// DomainSegmentPolicyAndTs is a struct that contains the DomainSegmentPolicy value & time
type DomainSegmentPolicyAndTs struct {
	Value *segmentation.DomainSegmentPolicy
	Time  time.Time
}

// DomainSegmentPolicyAndOperation holds a DomainSegmentPolicy and subscriptions.Operation.
type DomainSegmentPolicyAndOperation struct {
	Value     *segmentation.DomainSegmentPolicy
	Operation subscriptions.Operation
}

// DomainSegmentPolicyReader is an interface which abstracts how your resource can be read from
// Aeris (which may differ drastically from how it writes).
type DomainSegmentPolicyReader interface {
	// Because the hook runner only uses the Reader and Writer interface,
	// the type implementing this interface must also implement Mapper.
	DomainSegmentPolicyMapper

	// AllowGetAll allows the rpc to expose the GetAll method, while also being able to specify
	// that it is currently unsupported (but may be at a later date) and provide the relevant
	// response code for why.
	//
	// In practice, this should almost always return codes.OK, however, there may be concerns over
	// the scale (or technical unfeasability) of gathering the data.
	//
	// If this function does return any error code, the rationale and behavior should be properly
	// documented for clients so they do no expect results from this method.
	AllowGetAll(context.Context) codes.Code

	// ValidSubscribe is given the DomainSegmentPolicyStreamRequest received by the server and is expected
	// to verify that this operation is valid/allowed. Validation may include (but not limited to):
	//
	//     - are subscriptions allowed on this resource with/without filters
	//     - do filters contain disallowed fields
	//     - do time-range parameters make sense
	//
	// The message contained in a returned error will be sent to the client. This message
	// should sufficiently explain how the user can correct the issue, but not so verbose
	// as to expose implementation and/or internal details. Logging should be used for
	// more informative errors.
	ValidateSubscribe(context.Context, *segmentation.DomainSegmentPolicyStreamRequest) *status.Status

	// FormatUpdate is called on each notification in a notification batch
	// returned by a subscription and returns a series of DomainSegmentPolicy and operation
	// to be tested by the filter. The operation should never be set to
	// INITIAL_SYNC_COMPLETE as this operation is handled by the calling code. If
	// the operation is not set (i.e. it's UNSPECIFIED), then the calling code
	// sets it to either INITIAL or UPDATED depending on the subscription phase.
	// This phase is indicated by the first parameter; if true, it indicates that
	// the update is initial state and, if false, that it is non-initial state.
	//
	// It is up to the implementor to extract the model's key(s) from the notification.
	// Similarly, you must call .Updates() to get the modified fields and you
	// may also optionally inspect the timestamp if re-ordering is required.
	//
	// Deletes contained in this notification should be ignored as they are
	// passed to FormatDelete rather than this method.
	//
	// To drop a notification, return an empty slice.
	// Returned errors will be logged, but will not terminate the subscription.
	FormatUpdate(context.Context, bool, types.Notification) ([]DomainSegmentPolicyAndOperation, error)

	// OnInitialSyncComplete is called just before a subscription indicates to
	// the client that the initial state has all been sent. This method gives
	// the implementor a chance to send any additional resources that it may
	// have been holding onto.
	OnInitialSyncComplete(context.Context) ([]*DomainSegmentPolicyAndTs, error)

	// Get fetches a single entity from Aeris.
	// The given Path is the result of calling MakePath. The Options struct is derived
	// from the request by the hooks-runner and can (generally) be passed to the Aeris client.
	// Implementors are allowed to modify the options so long as they respect what was given
	// in the request.
	//
	// Returning nil indicates that the resource does not exist and NotFound will be
	// returned to the client.
	//
	// The returned timestamp must be either (in order of precedence):
	//
	//     1. the timestamp received within the notification for this read (if applicable)
	//     2. the End timestamp within client.Options (if set)
	//     3. the time immediately after the read operation returned
	//
	// This convention allows the returned timestamp to always return a
	// relevant entry when the returned time is used as an End parameter to a later fetch.
	//
	// The message contained in a returned error will be sent to the client. This message
	// should sufficiently explain how the user can correct the issue, but not so verbose
	// as to expose implementation and/or internal details. Logging should be used for
	// more informative errors.
	Get(
		context.Context,
		key.Path, []key.Key,
		*api.Options,
	) (*segmentation.DomainSegmentPolicy, time.Time, *status.Status)

	// GetAll feeds all or a subset (based on the request filters) of the instances
	// of DomainSegmentPolicy in Aeris to the client via the channel passed into the method.
	//
	// The client.Options argument is the result of converting the arista.time.TimeRange
	// in the request into options usable with Aeris clients.
	//
	// It is the responsibility of the implementer to close the channel passed to
	// GetAll before returning.
	//
	// Returning without sending on the channel results in no stream messages sent to the client.
	GetAll(context.Context, *segmentation.DomainSegmentPolicyStreamRequest, *api.Options,
		chan<- DomainSegmentPolicyAndTs) *status.Status
	// Subscribe hands control of the entire subscription over to an individual service, allowing
	// the service to do whatever it wants with the Subscribe() API, instead of the Aeris-specific
	// way most resource APIs deal with things. It will eventually be replaced with a suite of
	// gNMI-specific methods that can be called in a similar way to Aeris-specific interface methods
	Subscribe(ctx context.Context, req *segmentation.DomainSegmentPolicyStreamRequest,
		stream segmentation.DomainSegmentPolicyService_SubscribeServer) error
}

// DomainSegmentPolicyGetSomeError is the key that failed to read and how it failed.
// This error is user-facing and should read as such.
type DomainSegmentPolicyGetSomeError struct {
	Key   *segmentation.DomainSegmentPolicyKey
	Error error
}

// DomainSegmentPolicyGetSomeOverride allows for writing a "custom" GetSome implementation
// that is more efficient than the default (calling Get(...) in a loop).
//
// The implementor should attempt to send all responses into the channel resp.
// The implementor should close the channel resp when all responses have been sent.
// Any significant error should be returned.
// Any error returned will lead to a "code.Internal" error status on the request.
type DomainSegmentPolicyGetSomeOverride interface {
	GetSomeOverride(
		ctx context.Context,
		req *segmentation.DomainSegmentPolicySomeRequest,
		resp chan<- *segmentation.DomainSegmentPolicySomeResponse,
	) error
}

// DomainSegmentPolicySubscribeBookends allows for custom behavior at the beginning and end of each
// Subscribe call. This is useful, for instance, if you need maintain some state that
// only lasts the duration of the call.
type DomainSegmentPolicySubscribeBookends interface {
	// OnSubscribeStart is called at the beginning of Subscribe. It takes a pointer
	// to the context that was passed to Subscribe, allowing it to be overidden. E.g.,
	//
	// *ctx = context.WithValue(*ctx, ...)
	//
	// The Subscribe request is also passed to this method for additional context.
	OnSubscribeStart(ctx *context.Context, req *segmentation.DomainSegmentPolicyStreamRequest) *status.Status
	// OnSubscribeEnd is called just before Subscribe ends.
	OnSubscribeEnd(ctx context.Context, req *segmentation.DomainSegmentPolicyStreamRequest) error
}

// DomainSegmentPolicyConfigBase is an interface that provides the Aeris connection.
type DomainSegmentPolicyConfigBase interface {
	// Connection returns the connection being used to read from Aeris.
	// This connection is only used by the runner for subscriptions,
	// but should be readily available or constructible.
	Connection() *grpc.ClientConn
}

// DomainSegmentPolicyConfigMapper is an interface that declares where from Aeris to read data.
type DomainSegmentPolicyConfigMapper interface {

	// PathOf is given a request and is expected to return a valid Aeris path to the object.
	//
	// This result is used purely internally for KeyOf and Get. Only these methods needs
	// to interpret this path+keys, so the returned result can be an implementation detail.
	// Implementations are free to use or ignore the key array as necessary.
	//
	// If the path cannot be constructed, an error should be returned. This error will be logged
	// and an Internal error will be sent to the client.
	PathOf(context.Context, *segmentation.DomainSegmentPolicyKey) (key.Path, []key.Key,
		error)
	// KeyOf is given an Aeris path (generally from an update notif) and is expected to return a
	// valid DomainSegmentPolicyKey to return to the client.
	//
	// If the key struct cannot be constructed, an error should be returned.
	// This error will be logged and an Internal error will be sent to the client.
	KeyOf(context.Context, key.Path, key.Key) (*segmentation.DomainSegmentPolicyKey, error)

	// SubscribeRequests takes the stream request and returns information about 0 or
	// more Aeris subscriptions which should be initiated and run until either
	// completion or cancellation of the request context.
	//
	// This function should heavily consider optimizations of this request,
	// especially as it pertains to subscriptions. Examples:
	//
	//     - single filter + has key           -> subscribe to single path
	//     - many filters  + all have keys     -> subscribe to N paths (but not all)
	//     - many filters  + not all have keys -> subscribe to all (avoid dupes)
	//
	// This function is given the context from the request as well as the request
	// to the method which spawned this call. The passed in request should be
	// expected to be the {Resource}StreamRequest as defined in your proto.
	//
	// If the returned slice is empty, the runner will assume there is no work to
	// be done and the streaming handler will return, closing the stream to the client.
	//
	// All results of the subscription(s) are passed through Reader.FormatUpdate
	// before being sent to the client.
	SubscribeRequests(context.Context, *segmentation.DomainSegmentPolicyConfigStreamRequest) []rclient.SubscribeInfo
}

// DomainSegmentPolicyConfigAndTs is a struct that contains the DomainSegmentPolicyConfig value & time
type DomainSegmentPolicyConfigAndTs struct {
	Value *segmentation.DomainSegmentPolicyConfig
	Time  time.Time
}

// DomainSegmentPolicyConfigAndOperation holds a DomainSegmentPolicyConfig and subscriptions.Operation.
type DomainSegmentPolicyConfigAndOperation struct {
	Value     *segmentation.DomainSegmentPolicyConfig
	Operation subscriptions.Operation
}

// DomainSegmentPolicyConfigReader is an interface which abstracts how your resource can be read from
// Aeris (which may differ drastically from how it writes).
type DomainSegmentPolicyConfigReader interface {
	// Because the hook runner only uses the Reader and Writer interface,
	// the type implementing this interface must also implement Mapper.
	DomainSegmentPolicyConfigMapper

	// AllowGetAll allows the rpc to expose the GetAll method, while also being able to specify
	// that it is currently unsupported (but may be at a later date) and provide the relevant
	// response code for why.
	//
	// In practice, this should almost always return codes.OK, however, there may be concerns over
	// the scale (or technical unfeasability) of gathering the data.
	//
	// If this function does return any error code, the rationale and behavior should be properly
	// documented for clients so they do no expect results from this method.
	AllowGetAll(context.Context) codes.Code

	// ValidSubscribe is given the DomainSegmentPolicyConfigStreamRequest received by the server and is expected
	// to verify that this operation is valid/allowed. Validation may include (but not limited to):
	//
	//     - are subscriptions allowed on this resource with/without filters
	//     - do filters contain disallowed fields
	//     - do time-range parameters make sense
	//
	// The message contained in a returned error will be sent to the client. This message
	// should sufficiently explain how the user can correct the issue, but not so verbose
	// as to expose implementation and/or internal details. Logging should be used for
	// more informative errors.
	ValidateSubscribe(context.Context, *segmentation.DomainSegmentPolicyConfigStreamRequest) *status.Status

	// FormatUpdate is called on each notification in a notification batch
	// returned by a subscription and returns a series of DomainSegmentPolicyConfig and operation
	// to be tested by the filter. The operation should never be set to
	// INITIAL_SYNC_COMPLETE as this operation is handled by the calling code. If
	// the operation is not set (i.e. it's UNSPECIFIED), then the calling code
	// sets it to either INITIAL or UPDATED depending on the subscription phase.
	// This phase is indicated by the first parameter; if true, it indicates that
	// the update is initial state and, if false, that it is non-initial state.
	//
	// It is up to the implementor to extract the model's key(s) from the notification.
	// Similarly, you must call .Updates() to get the modified fields and you
	// may also optionally inspect the timestamp if re-ordering is required.
	//
	// Deletes contained in this notification should be ignored as they are
	// passed to FormatDelete rather than this method.
	//
	// To drop a notification, return an empty slice.
	// Returned errors will be logged, but will not terminate the subscription.
	FormatUpdate(context.Context, bool, types.Notification) ([]DomainSegmentPolicyConfigAndOperation, error)

	// OnInitialSyncComplete is called just before a subscription indicates to
	// the client that the initial state has all been sent. This method gives
	// the implementor a chance to send any additional resources that it may
	// have been holding onto.
	OnInitialSyncComplete(context.Context) ([]*DomainSegmentPolicyConfigAndTs, error)

	// Get fetches a single entity from Aeris.
	// The given Path is the result of calling MakePath. The Options struct is derived
	// from the request by the hooks-runner and can (generally) be passed to the Aeris client.
	// Implementors are allowed to modify the options so long as they respect what was given
	// in the request.
	//
	// Returning nil indicates that the resource does not exist and NotFound will be
	// returned to the client.
	//
	// The returned timestamp must be either (in order of precedence):
	//
	//     1. the timestamp received within the notification for this read (if applicable)
	//     2. the End timestamp within client.Options (if set)
	//     3. the time immediately after the read operation returned
	//
	// This convention allows the returned timestamp to always return a
	// relevant entry when the returned time is used as an End parameter to a later fetch.
	//
	// The message contained in a returned error will be sent to the client. This message
	// should sufficiently explain how the user can correct the issue, but not so verbose
	// as to expose implementation and/or internal details. Logging should be used for
	// more informative errors.
	Get(
		context.Context,
		key.Path, []key.Key,
		*api.Options,
	) (*segmentation.DomainSegmentPolicyConfig, time.Time, *status.Status)

	// GetAll feeds all or a subset (based on the request filters) of the instances
	// of DomainSegmentPolicyConfig in Aeris to the client via the channel passed into the method.
	//
	// The client.Options argument is the result of converting the arista.time.TimeRange
	// in the request into options usable with Aeris clients.
	//
	// It is the responsibility of the implementer to close the channel passed to
	// GetAll before returning.
	//
	// Returning without sending on the channel results in no stream messages sent to the client.
	GetAll(context.Context, *segmentation.DomainSegmentPolicyConfigStreamRequest, *api.Options,
		chan<- DomainSegmentPolicyConfigAndTs) *status.Status
	// Subscribe hands control of the entire subscription over to an individual service, allowing
	// the service to do whatever it wants with the Subscribe() API, instead of the Aeris-specific
	// way most resource APIs deal with things. It will eventually be replaced with a suite of
	// gNMI-specific methods that can be called in a similar way to Aeris-specific interface methods
	Subscribe(ctx context.Context, req *segmentation.DomainSegmentPolicyConfigStreamRequest,
		stream segmentation.DomainSegmentPolicyConfigService_SubscribeServer) error
}

// DomainSegmentPolicyConfigGetSomeError is the key that failed to read and how it failed.
// This error is user-facing and should read as such.
type DomainSegmentPolicyConfigGetSomeError struct {
	Key   *segmentation.DomainSegmentPolicyKey
	Error error
}

// DomainSegmentPolicyConfigGetSomeOverride allows for writing a "custom" GetSome implementation
// that is more efficient than the default (calling Get(...) in a loop).
//
// The implementor should attempt to send all responses into the channel resp.
// The implementor should close the channel resp when all responses have been sent.
// Any significant error should be returned.
// Any error returned will lead to a "code.Internal" error status on the request.
type DomainSegmentPolicyConfigGetSomeOverride interface {
	GetSomeOverride(
		ctx context.Context,
		req *segmentation.DomainSegmentPolicyConfigSomeRequest,
		resp chan<- *segmentation.DomainSegmentPolicyConfigSomeResponse,
	) error
}

// DomainSegmentPolicyConfigSubscribeBookends allows for custom behavior at the beginning and end of each
// Subscribe call. This is useful, for instance, if you need maintain some state that
// only lasts the duration of the call.
type DomainSegmentPolicyConfigSubscribeBookends interface {
	// OnSubscribeStart is called at the beginning of Subscribe. It takes a pointer
	// to the context that was passed to Subscribe, allowing it to be overidden. E.g.,
	//
	// *ctx = context.WithValue(*ctx, ...)
	//
	// The Subscribe request is also passed to this method for additional context.
	OnSubscribeStart(ctx *context.Context, req *segmentation.DomainSegmentPolicyConfigStreamRequest) *status.Status
	// OnSubscribeEnd is called just before Subscribe ends.
	OnSubscribeEnd(ctx context.Context, req *segmentation.DomainSegmentPolicyConfigStreamRequest) error
}

// DeletedDomainSegmentPolicyConfigAndTs is a struct that holds the delete error TypeAndError,
// DomainSegmentPolicyKey and time
type DeletedDomainSegmentPolicyConfigAndTs struct {
	TypeAndError rclient.DeletionError
	Key          *segmentation.DomainSegmentPolicyKey
	Time         time.Time
}

type DomainSegmentPolicyConfigAllDeleter interface {
	// DeleteAllHandler is expected to delete every key in a resource collection.
	// When DeleteAllHandler is implemented, rpc DeleteAll will call DeleteAllHandler.
	// If all keys are deleted successfully, the service will close the RPC gracefully.
	// The returned timestamp will have the timestamp used when publishing to Aeris.
	//
	// It is the responsibility of the implementer to close the channel passed to
	// DeleteAllHandler before returning.
	//
	// If a service begins deleting data from storage and some keys are deleted but
	// others fail, it should return over a channel the DeleteError for the keys it fails
	// to delete in the DeleteResponse (in DeletedDomainSegmentPolicyConfigAndTs).
	// If a service runs into any error before deleting any key, it will return
	// a single response with an appropriate DeleteError and error message,
	// without setting any key, and close the RPC.
	DeleteAllHandler(context.Context,
		*segmentation.DomainSegmentPolicyConfigDeleteAllRequest, chan<- DeletedDomainSegmentPolicyConfigAndTs) *status.Status
}

type DomainSegmentPolicyConfigPathDeleter interface {
	// GetDeletePaths specifies a set of paths to delete and a dataset to delete from.
	// Wildcards are permitted.
	//
	// If all keys from the paths are deleted successfully,
	// the service will close the RPC gracefully.
	//
	// If a service begins deleting data from storage and some keys are deleted but others
	// fail, it should return the keys it fails to delete in the DeleteResponse
	//
	// If a service runs into any error before deleting any key, it will
	// return a single response with an appropriate DeleteError and error message,
	// without setting any key, and close the RPC.
	GetDeletePaths(context.Context) ([]key.Path, pb.Dataset, error)
}

// DomainSegmentPolicyConfigSetSomeError is the key that failed to write and how it failed.
// This error is user-facing and should read as such.
type DomainSegmentPolicyConfigSetSomeError struct {
	Key   *segmentation.DomainSegmentPolicyKey
	Error error
}

// DomainSegmentPolicyConfigSetSomeOverride allows for writing a "custom" SetSome implementation
// that is more efficient than the default (calling Write(...) in a loop).
//
// The implementor should attempt write all values into storage and return all errors that occur.
// The returned errors will be sent to the client so they should be user-approriate.
// Any errors returned will lead to a "code.Internal" error status on the request.
//
// When overriding, values __will not__ have been passed to ValidateWrite so this must be
// taken care of. While hooks-runner is capable of calling it, we'd have to track values
// which have and have not passed validation. This causes unnecessary memory usage for something
// that could just be returned as an error from this function.
type DomainSegmentPolicyConfigSetSomeOverride interface {
	SetSomeOverride(ctx context.Context, req *segmentation.DomainSegmentPolicyConfigSetSomeRequest) []DomainSegmentPolicyConfigSetSomeError
}

// DomainSegmentPolicyConfigDeleteSomeError is the key that failed to delete and how it failed.
// DomainSegmentPolicyConfigDeleteSomeError is only sent when there is an error.
// This error is user-facing and should read as such.
type DomainSegmentPolicyConfigDeleteSomeError struct {
	Key   *segmentation.DomainSegmentPolicyKey
	Error error
}

// DomainSegmentPolicyConfigDeleteSomeOverride allows for writing a "custom" DeleteSome implementation
// that is more efficient than the default (calling Delete(...) in a loop).
//
// The implementor should attempt delete all values from storage and return all errors that occur.
// The returned errors will be sent to the client so they should be user-approriate.
// Any errors returned will lead to a "code.Internal" error status on the request.
type DomainSegmentPolicyConfigDeleteSomeOverride interface {
	DeleteSomeOverride(ctx context.Context, req *segmentation.DomainSegmentPolicyConfigDeleteSomeRequest) []DomainSegmentPolicyConfigDeleteSomeError
}

// DomainSegmentPolicyConfigWriter is an abstraction over how your service will write resources into Aeris.
// All validation will be done before the call to Write or Delete, so those methods can
// simply implement the required action.
type DomainSegmentPolicyConfigWriter interface {
	// ValidateWrite is given the DomainSegmentPolicyConfig within a DomainSegmentPolicyConfigWriteRequest and is expected to
	// return any errors with the request. Validation may include (but not limited to):
	//
	//     - checking all required fields are given
	//     - provided fields are valid (format, contents, etc.)
	//     - if server-generated fields are given, handle as update
	//         - should probably only be allowed as part of the Key
	//         - verify validity/existence/etc to avoid accidental overwrites
	//
	// The message contained in a returned error will be sent to the client. This message
	// should sufficiently explain how the user can correct the issue, but not so verbose
	// as to expose implementation and/or internal details. Logging should be used for
	// more informative errors.
	ValidateWrite(context.Context, *segmentation.DomainSegmentPolicyConfig) error

	// Write is expected to write the given DomainSegmentPolicyConfig into Aeris (and do any data
	// transformations required to match Aeris' schema before writing).
	//
	// The entity from the request is passed as a pointer so that any modifications made to
	// it are echoed back to the client. This is ideal for server-generated values. Simply
	// set the values on the entity before converting to Aeris-form.
	//
	// The returned timestamp must be either the timestamp associated with the notification
	// sent to Aeris for this write (if applicable) or the time immediately after the write
	// operation returned. This convention allows the returned timestamp to always return a
	// valid entry when the returned time is used as an End parameter to a later fetch.
	//
	// The message contained in a returned error will be sent to the client. This message
	// should sufficiently explain how the user can correct the issue, but not so verbose
	// as to expose implementation and/or internal details. Logging should be used for
	// more informative errors.
	Write(context.Context, *segmentation.DomainSegmentPolicyConfig) (time.Time, *status.Status)
	// Delete is expected to delete the entity within Aeris identified by the given key.
	//
	// The returned timestamp should be the same as the timestamp used when publishing
	// to Aeris. This allows clients to have a minimal timestamp for which the deleted
	// entity will not exist in future queries.
	//
	// The message contained in a returned error will be sent to the client. This message
	// should sufficiently explain how the user can correct the issue, but not so verbose
	// as to expose implementation and/or internal details. Logging should be used for
	// more informative errors.
	Delete(context.Context, *segmentation.DomainSegmentPolicyKey) (time.Time, *status.Status)
}

// PolicyConfigBase is an interface that provides the Aeris connection.
type PolicyConfigBase interface {
	// Connection returns the connection being used to read from Aeris.
	// This connection is only used by the runner for subscriptions,
	// but should be readily available or constructible.
	Connection() *grpc.ClientConn
}

// PolicyConfigMapper is an interface that declares where from Aeris to read data.
type PolicyConfigMapper interface {

	// PathOf is given a request and is expected to return a valid Aeris path to the object.
	//
	// This result is used purely internally for KeyOf and Get. Only these methods needs
	// to interpret this path+keys, so the returned result can be an implementation detail.
	// Implementations are free to use or ignore the key array as necessary.
	//
	// If the path cannot be constructed, an error should be returned. This error will be logged
	// and an Internal error will be sent to the client.
	PathOf(context.Context, *segmentation.PolicyKey) (key.Path, []key.Key,
		error)
	// KeyOf is given an Aeris path (generally from an update notif) and is expected to return a
	// valid PolicyKey to return to the client.
	//
	// If the key struct cannot be constructed, an error should be returned.
	// This error will be logged and an Internal error will be sent to the client.
	KeyOf(context.Context, key.Path, key.Key) (*segmentation.PolicyKey, error)

	// SubscribeRequests takes the stream request and returns information about 0 or
	// more Aeris subscriptions which should be initiated and run until either
	// completion or cancellation of the request context.
	//
	// This function should heavily consider optimizations of this request,
	// especially as it pertains to subscriptions. Examples:
	//
	//     - single filter + has key           -> subscribe to single path
	//     - many filters  + all have keys     -> subscribe to N paths (but not all)
	//     - many filters  + not all have keys -> subscribe to all (avoid dupes)
	//
	// This function is given the context from the request as well as the request
	// to the method which spawned this call. The passed in request should be
	// expected to be the {Resource}StreamRequest as defined in your proto.
	//
	// If the returned slice is empty, the runner will assume there is no work to
	// be done and the streaming handler will return, closing the stream to the client.
	//
	// All results of the subscription(s) are passed through Reader.FormatUpdate
	// before being sent to the client.
	SubscribeRequests(context.Context, *segmentation.PolicyConfigStreamRequest) []rclient.SubscribeInfo
}

// PolicyConfigAndTs is a struct that contains the PolicyConfig value & time
type PolicyConfigAndTs struct {
	Value *segmentation.PolicyConfig
	Time  time.Time
}

// PolicyConfigAndOperation holds a PolicyConfig and subscriptions.Operation.
type PolicyConfigAndOperation struct {
	Value     *segmentation.PolicyConfig
	Operation subscriptions.Operation
}

// PolicyConfigReader is an interface which abstracts how your resource can be read from
// Aeris (which may differ drastically from how it writes).
type PolicyConfigReader interface {
	// Because the hook runner only uses the Reader and Writer interface,
	// the type implementing this interface must also implement Mapper.
	PolicyConfigMapper

	// AllowGetAll allows the rpc to expose the GetAll method, while also being able to specify
	// that it is currently unsupported (but may be at a later date) and provide the relevant
	// response code for why.
	//
	// In practice, this should almost always return codes.OK, however, there may be concerns over
	// the scale (or technical unfeasability) of gathering the data.
	//
	// If this function does return any error code, the rationale and behavior should be properly
	// documented for clients so they do no expect results from this method.
	AllowGetAll(context.Context) codes.Code

	// ValidSubscribe is given the PolicyConfigStreamRequest received by the server and is expected
	// to verify that this operation is valid/allowed. Validation may include (but not limited to):
	//
	//     - are subscriptions allowed on this resource with/without filters
	//     - do filters contain disallowed fields
	//     - do time-range parameters make sense
	//
	// The message contained in a returned error will be sent to the client. This message
	// should sufficiently explain how the user can correct the issue, but not so verbose
	// as to expose implementation and/or internal details. Logging should be used for
	// more informative errors.
	ValidateSubscribe(context.Context, *segmentation.PolicyConfigStreamRequest) *status.Status

	// FormatUpdate is called on each notification in a notification batch
	// returned by a subscription and returns a series of PolicyConfig and operation
	// to be tested by the filter. The operation should never be set to
	// INITIAL_SYNC_COMPLETE as this operation is handled by the calling code. If
	// the operation is not set (i.e. it's UNSPECIFIED), then the calling code
	// sets it to either INITIAL or UPDATED depending on the subscription phase.
	// This phase is indicated by the first parameter; if true, it indicates that
	// the update is initial state and, if false, that it is non-initial state.
	//
	// It is up to the implementor to extract the model's key(s) from the notification.
	// Similarly, you must call .Updates() to get the modified fields and you
	// may also optionally inspect the timestamp if re-ordering is required.
	//
	// Deletes contained in this notification should be ignored as they are
	// passed to FormatDelete rather than this method.
	//
	// To drop a notification, return an empty slice.
	// Returned errors will be logged, but will not terminate the subscription.
	FormatUpdate(context.Context, bool, types.Notification) ([]PolicyConfigAndOperation, error)

	// OnInitialSyncComplete is called just before a subscription indicates to
	// the client that the initial state has all been sent. This method gives
	// the implementor a chance to send any additional resources that it may
	// have been holding onto.
	OnInitialSyncComplete(context.Context) ([]*PolicyConfigAndTs, error)

	// Get fetches a single entity from Aeris.
	// The given Path is the result of calling MakePath. The Options struct is derived
	// from the request by the hooks-runner and can (generally) be passed to the Aeris client.
	// Implementors are allowed to modify the options so long as they respect what was given
	// in the request.
	//
	// Returning nil indicates that the resource does not exist and NotFound will be
	// returned to the client.
	//
	// The returned timestamp must be either (in order of precedence):
	//
	//     1. the timestamp received within the notification for this read (if applicable)
	//     2. the End timestamp within client.Options (if set)
	//     3. the time immediately after the read operation returned
	//
	// This convention allows the returned timestamp to always return a
	// relevant entry when the returned time is used as an End parameter to a later fetch.
	//
	// The message contained in a returned error will be sent to the client. This message
	// should sufficiently explain how the user can correct the issue, but not so verbose
	// as to expose implementation and/or internal details. Logging should be used for
	// more informative errors.
	Get(
		context.Context,
		key.Path, []key.Key,
		*api.Options,
	) (*segmentation.PolicyConfig, time.Time, *status.Status)

	// GetAll feeds all or a subset (based on the request filters) of the instances
	// of PolicyConfig in Aeris to the client via the channel passed into the method.
	//
	// The client.Options argument is the result of converting the arista.time.TimeRange
	// in the request into options usable with Aeris clients.
	//
	// It is the responsibility of the implementer to close the channel passed to
	// GetAll before returning.
	//
	// Returning without sending on the channel results in no stream messages sent to the client.
	GetAll(context.Context, *segmentation.PolicyConfigStreamRequest, *api.Options,
		chan<- PolicyConfigAndTs) *status.Status
	// Subscribe hands control of the entire subscription over to an individual service, allowing
	// the service to do whatever it wants with the Subscribe() API, instead of the Aeris-specific
	// way most resource APIs deal with things. It will eventually be replaced with a suite of
	// gNMI-specific methods that can be called in a similar way to Aeris-specific interface methods
	Subscribe(ctx context.Context, req *segmentation.PolicyConfigStreamRequest,
		stream segmentation.PolicyConfigService_SubscribeServer) error
}

// PolicyConfigGetSomeError is the key that failed to read and how it failed.
// This error is user-facing and should read as such.
type PolicyConfigGetSomeError struct {
	Key   *segmentation.PolicyKey
	Error error
}

// PolicyConfigGetSomeOverride allows for writing a "custom" GetSome implementation
// that is more efficient than the default (calling Get(...) in a loop).
//
// The implementor should attempt to send all responses into the channel resp.
// The implementor should close the channel resp when all responses have been sent.
// Any significant error should be returned.
// Any error returned will lead to a "code.Internal" error status on the request.
type PolicyConfigGetSomeOverride interface {
	GetSomeOverride(
		ctx context.Context,
		req *segmentation.PolicyConfigSomeRequest,
		resp chan<- *segmentation.PolicyConfigSomeResponse,
	) error
}

// PolicyConfigSubscribeBookends allows for custom behavior at the beginning and end of each
// Subscribe call. This is useful, for instance, if you need maintain some state that
// only lasts the duration of the call.
type PolicyConfigSubscribeBookends interface {
	// OnSubscribeStart is called at the beginning of Subscribe. It takes a pointer
	// to the context that was passed to Subscribe, allowing it to be overidden. E.g.,
	//
	// *ctx = context.WithValue(*ctx, ...)
	//
	// The Subscribe request is also passed to this method for additional context.
	OnSubscribeStart(ctx *context.Context, req *segmentation.PolicyConfigStreamRequest) *status.Status
	// OnSubscribeEnd is called just before Subscribe ends.
	OnSubscribeEnd(ctx context.Context, req *segmentation.PolicyConfigStreamRequest) error
}

// DeletedPolicyConfigAndTs is a struct that holds the delete error TypeAndError,
// PolicyKey and time
type DeletedPolicyConfigAndTs struct {
	TypeAndError rclient.DeletionError
	Key          *segmentation.PolicyKey
	Time         time.Time
}

type PolicyConfigAllDeleter interface {
	// DeleteAllHandler is expected to delete every key in a resource collection.
	// When DeleteAllHandler is implemented, rpc DeleteAll will call DeleteAllHandler.
	// If all keys are deleted successfully, the service will close the RPC gracefully.
	// The returned timestamp will have the timestamp used when publishing to Aeris.
	//
	// It is the responsibility of the implementer to close the channel passed to
	// DeleteAllHandler before returning.
	//
	// If a service begins deleting data from storage and some keys are deleted but
	// others fail, it should return over a channel the DeleteError for the keys it fails
	// to delete in the DeleteResponse (in DeletedPolicyConfigAndTs).
	// If a service runs into any error before deleting any key, it will return
	// a single response with an appropriate DeleteError and error message,
	// without setting any key, and close the RPC.
	DeleteAllHandler(context.Context,
		*segmentation.PolicyConfigDeleteAllRequest, chan<- DeletedPolicyConfigAndTs) *status.Status
}

type PolicyConfigPathDeleter interface {
	// GetDeletePaths specifies a set of paths to delete and a dataset to delete from.
	// Wildcards are permitted.
	//
	// If all keys from the paths are deleted successfully,
	// the service will close the RPC gracefully.
	//
	// If a service begins deleting data from storage and some keys are deleted but others
	// fail, it should return the keys it fails to delete in the DeleteResponse
	//
	// If a service runs into any error before deleting any key, it will
	// return a single response with an appropriate DeleteError and error message,
	// without setting any key, and close the RPC.
	GetDeletePaths(context.Context) ([]key.Path, pb.Dataset, error)
}

// PolicyConfigSetSomeError is the key that failed to write and how it failed.
// This error is user-facing and should read as such.
type PolicyConfigSetSomeError struct {
	Key   *segmentation.PolicyKey
	Error error
}

// PolicyConfigSetSomeOverride allows for writing a "custom" SetSome implementation
// that is more efficient than the default (calling Write(...) in a loop).
//
// The implementor should attempt write all values into storage and return all errors that occur.
// The returned errors will be sent to the client so they should be user-approriate.
// Any errors returned will lead to a "code.Internal" error status on the request.
//
// When overriding, values __will not__ have been passed to ValidateWrite so this must be
// taken care of. While hooks-runner is capable of calling it, we'd have to track values
// which have and have not passed validation. This causes unnecessary memory usage for something
// that could just be returned as an error from this function.
type PolicyConfigSetSomeOverride interface {
	SetSomeOverride(ctx context.Context, req *segmentation.PolicyConfigSetSomeRequest) []PolicyConfigSetSomeError
}

// PolicyConfigDeleteSomeError is the key that failed to delete and how it failed.
// PolicyConfigDeleteSomeError is only sent when there is an error.
// This error is user-facing and should read as such.
type PolicyConfigDeleteSomeError struct {
	Key   *segmentation.PolicyKey
	Error error
}

// PolicyConfigDeleteSomeOverride allows for writing a "custom" DeleteSome implementation
// that is more efficient than the default (calling Delete(...) in a loop).
//
// The implementor should attempt delete all values from storage and return all errors that occur.
// The returned errors will be sent to the client so they should be user-approriate.
// Any errors returned will lead to a "code.Internal" error status on the request.
type PolicyConfigDeleteSomeOverride interface {
	DeleteSomeOverride(ctx context.Context, req *segmentation.PolicyConfigDeleteSomeRequest) []PolicyConfigDeleteSomeError
}

// PolicyConfigWriter is an abstraction over how your service will write resources into Aeris.
// All validation will be done before the call to Write or Delete, so those methods can
// simply implement the required action.
type PolicyConfigWriter interface {
	// ValidateWrite is given the PolicyConfig within a PolicyConfigWriteRequest and is expected to
	// return any errors with the request. Validation may include (but not limited to):
	//
	//     - checking all required fields are given
	//     - provided fields are valid (format, contents, etc.)
	//     - if server-generated fields are given, handle as update
	//         - should probably only be allowed as part of the Key
	//         - verify validity/existence/etc to avoid accidental overwrites
	//
	// The message contained in a returned error will be sent to the client. This message
	// should sufficiently explain how the user can correct the issue, but not so verbose
	// as to expose implementation and/or internal details. Logging should be used for
	// more informative errors.
	ValidateWrite(context.Context, *segmentation.PolicyConfig) error

	// Write is expected to write the given PolicyConfig into Aeris (and do any data
	// transformations required to match Aeris' schema before writing).
	//
	// The entity from the request is passed as a pointer so that any modifications made to
	// it are echoed back to the client. This is ideal for server-generated values. Simply
	// set the values on the entity before converting to Aeris-form.
	//
	// The returned timestamp must be either the timestamp associated with the notification
	// sent to Aeris for this write (if applicable) or the time immediately after the write
	// operation returned. This convention allows the returned timestamp to always return a
	// valid entry when the returned time is used as an End parameter to a later fetch.
	//
	// The message contained in a returned error will be sent to the client. This message
	// should sufficiently explain how the user can correct the issue, but not so verbose
	// as to expose implementation and/or internal details. Logging should be used for
	// more informative errors.
	Write(context.Context, *segmentation.PolicyConfig) (time.Time, *status.Status)
	// Delete is expected to delete the entity within Aeris identified by the given key.
	//
	// The returned timestamp should be the same as the timestamp used when publishing
	// to Aeris. This allows clients to have a minimal timestamp for which the deleted
	// entity will not exist in future queries.
	//
	// The message contained in a returned error will be sent to the client. This message
	// should sufficiently explain how the user can correct the issue, but not so verbose
	// as to expose implementation and/or internal details. Logging should be used for
	// more informative errors.
	Delete(context.Context, *segmentation.PolicyKey) (time.Time, *status.Status)
}
