# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# N.B. If you edit this file you must regenerate and replace
# the associated AsuPatch patch RPM. For more information see
# /src/AsuPatch/packages/README.

from __future__ import absolute_import, division, print_function
import subprocess
import AsuPStore
import Tracing

t0 = Tracing.trace0

class AclAgentPStoreEventHandler( AsuPStore.PStoreEventHandler ):

   def __init__( self ):
      AsuPStore.PStoreEventHandler.__init__( self )

   def getIptables( self, cmd ):
      fullCmd = [ 'sudo', '-E' ] + cmd[ : ]
      # Can't use TacUtils.run() as it doesn't exist in older releases
      output = subprocess.check_output( fullCmd, universal_newlines=True )
      return output

   def storeIptables( self ):
      iptables = self.getIptables( [ 'iptables-save' ] )
      return iptables 

   def storeIp6tables( self ):
      ip6tables = self.getIptables( [ 'ip6tables-save' ] )
      return ip6tables 

   def save( self, pStoreIO ):
      info = self.storeIptables()
      pStoreIO.set( 'iptables', info )
      info = self.storeIp6tables()
      pStoreIO.set( 'ip6tables', info )

   def getSupportedKeys( self ):
      return [ 'iptables', 'ip6tables' ]

   def getKeys( self ):
      return [ 'iptables', 'ip6tables' ]

def Plugin( ctx ):
   ctx.registerAsuPStoreEventHandler( 'AclAgent', AclAgentPStoreEventHandler() )
