#!/usr/bin/env python
# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# N.B. If you edit this file you must regenerate and replace
# the associated AsuPatch patch RPM. For more information see
# /src/AsuPatch/packages/README.

import AsuPStore
import Tracing

t0 = Tracing.trace0

class AleMroutePStoreEventHandler( AsuPStore.PStoreEventHandler ):

   def __init__( self, mfibHwStatus ):
      AsuPStore.PStoreEventHandler.__init__( self )
      self.mfibHwStatus_ = mfibHwStatus

   def storeMfibHwStatus( self ):
      pstoreInfo = {}
      vrfStatus = self.mfibHwStatus_.vrfStatus
      for vrf in vrfStatus.keys():
         rs = vrfStatus[ vrf ].route
         for sg in rs.keys():
            if vrf not in pstoreInfo:
               pstoreInfo[ vrf ] = []
            entry = [ str( sg.s ), str( sg.g ), rs[ sg ].acceptingIntfId ]
            pstoreInfo[ vrf ].append( entry )
      return pstoreInfo

   def save( self, pStoreIO ):
      info = self.storeMfibHwStatus()
      pStoreIO.set( 'mfibSgEntries', info )

   def getSupportedKeys( self ):
      return [ 'mfibSgEntries' ]

   def getKeys( self ):
      return [ 'mfibSgEntries' ]

def Plugin( ctx ):

   featureName = "AleMroute"
   t0( "opcode is", ctx.opcode() )
   if ctx.opcode() == 'GetSupportedKeys':
      ctx.registerAsuPStoreEventHandler( featureName,
                                         AleMroutePStoreEventHandler( None ) )
      return
   entityManager = ctx.entityManager()
   mg = entityManager.mountGroup()
   hwStatus = mg.mount( 'routing/hardware/multicast/status',
                        'Routing::Multicast::Fib::Hardware::Status',
                        'r' )
   mg.close( blocking=True )
   ctx.registerAsuPStoreEventHandler(
      featureName, AleMroutePStoreEventHandler( hwStatus ) )
