# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import sys
from AsuPatchBase import AsuPatchBase

class NatAsuPatchHelper( AsuPatchBase ):
   def __init__( self ):
      AsuPatchBase.__init__( self, "NatAsuPStore" )

   def check( self ):
      return 0

   def reboot( self ):
      # Flush possible previous version of the plugin so we are
      # guaranteed the version we just installed runs during ASU
      # Patch
      sys.modules.pop( "AsuPStorePlugin.NatAsuPStore", None )
      return 0

   def cleanup( self ):
      return 0

_natAsuPatchHelper = NatAsuPatchHelper()

def execute( stageVal, *args, **kwargs ):
   return _natAsuPatchHelper.execute( stageVal, *args, **kwargs )
