# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import sys
from AsuPatchBase import AsuPatchBase

class SandAsuPatchHelper( AsuPatchBase ):
   def __init__( self ):
      AsuPatchBase.__init__( self, "SandPlatformFastPktRestoreAsuPStore" )

   def check( self ):
      return 0

   def reboot( self ):
      # Flush possible previous version of the plugin so we are
      # guaranteed the version we just installed runs during ASU
      # Patch
      sys.modules.pop( "AsuPStorePlugin.SandFastPktAsuPStore", None )
      return 0

   def cleanup( self ):
      return 0

_sandAsuPatchHelper = SandAsuPatchHelper()

def execute( stageVal, *args, **kwargs ):
   return _sandAsuPatchHelper.execute( stageVal, *args, **kwargs )
