# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
import Cell
import Tac
import re
import sys
import threading
import StrataAttributes

# Force reload the latest AsuPatchBase from swi
# pylint: disable-msg=import-error
# pylint: disable-msg=wrong-import-position
sys.modules.pop( 'AsuPatchBase', None )
import AsuPatchBase

class DmaShutdownThread( threading.Thread ):
   def __init__( self, patch ):
      self.patch = patch
      super( DmaShutdownThread, self ).__init__()

   def addDynamicStage( self ):
      self.patch.log( 'Adding new dependency on DmaDriverShutdown' )
      cmd = [ 'python', '-m' 'Acons', 'Sysdb' ]
      stageAddition = 'cd /ar/Sysdb/%s' % Cell.path( "stageAgentStatus/shutdown" )
      stageAddition += \
         '\n_.newEntity( "Stage::AgentStatus", "AsuPatch" )'
      stageAddition += '\ncd AsuPatch'
      stageAddition += '\nstageRequest = Tac.newInstance( "Stage::StageRequest",' + \
         '"AsuPatch", "DmaDriverShutdown", 30 )'
      stageAddition += '\n_.stageRequest.addMember( stageRequest )'
      Tac.run( cmd, input=stageAddition, asRoot=True,
               stdout=Tac.CAPTURE, stderr=Tac.CAPTURE )

   def dmaDriverShutdownStageInProgress( self ):
      try:
         cmd = [ 'python', '-m' 'Acons', 'Sysdb' ]
         stageProgress = \
            'cd /ar/Sysdb/%s' % Cell.path( "stage/shutdown/progress/default" )
         stageProgress += '\n"DmaDriverShutdown" in _.stage'
         output = Tac.run( cmd, input=stageProgress, asRoot=True,
                           stdout=Tac.CAPTURE, stderr=Tac.CAPTURE )
         m = re.search( 'True', output )
         return m is not None
      except: # pylint: disable=bare-except
         return False

   def devstateDown( self ):
      self.patch.log( 'Fab devstate down' )
      Tac.run( [ "fab", "devstate", "1", "down" ], asRoot=True )

   def dmaDriverShutdownComplete( self ):
      self.patch.log( 'Completing stage DmaDriverShutdown for AsuPatch' )
      cmd = [ 'python', '-m' 'Acons', 'Sysdb' ]
      stageComplete = \
         'cd /ar/Sysdb/%s' % Cell.path( "stageAgentStatus/shutdown/AsuPatch" )
      stageComplete += '\nagentStatusKey = Tac.Value( "Stage::AgentStatusKey", ' + \
         '"AsuPatch", "DmaDriverShutdown", "default" )'
      stageComplete += '\n_.complete[ agentStatusKey ] = True'
      Tac.run( cmd, input=stageComplete, asRoot=True,
               stdout=Tac.CAPTURE, stderr=Tac.CAPTURE )

   def run( self ):
      self.addDynamicStage()
      Tac.waitFor( self.dmaDriverShutdownStageInProgress,
                   description='DmaDriverShutdown stage to start',
                   sleep=True, timeout=1200 )
      self.devstateDown()
      self.dmaDriverShutdownComplete()

class StrataDmaShut( AsuPatchBase.AsuPatchBase ):
   def check( self ):
      return 0

   def reboot( self ):
      attr = StrataAttributes.strataAttributes()
      for chip in attr.chip:
         if chip.model == 'bcm56870' or chip.model == 'bcm56770':
            thread = DmaShutdownThread( self )
            thread.start()
            return 0

      return 0

def execute( stageVal, *args, **kwargs ):
   obj = StrataDmaShut( 'StrataDmaShut' )
   return obj.execute( stageVal, *args, **kwargs )
