/*
 * Decompiled with CFR 0.152.
 */
package com.vsiptv.VLite;

import com.vsiptv.VLite.User;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

@WebFilter(filterName="LoginFilter", urlPatterns={"/", "/config", "/routing"})
public class LoginFilter
implements Filter {
    private static final Logger logger = Logger.getLogger("LoginFilter");
    private static final boolean debug = false;
    private FilterConfig filterConfig = null;

    public LoginFilter() {
        logger.setLevel(Level.FINEST);
    }

    private void doBeforeProcessing(ServletRequest request, ServletResponse response) throws IOException, ServletException {
    }

    private void doAfterProcessing(ServletRequest request, ServletResponse response) throws IOException, ServletException {
    }

    @Override
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        HttpSession session = request.getSession(false);
        boolean loggedIn = session != null && session.getAttribute("user") != null;
        String loginURI = request.getContextPath() + "/login";
        boolean loginRequest = request.getRequestURI().equals(loginURI);
        String configURI = request.getContextPath() + "/config";
        boolean configRequest = request.getRequestURI().equals(configURI);
        Throwable problem = null;
        try {
            if (loginRequest) {
                chain.doFilter(request, response);
            } else if (loggedIn) {
                if (configRequest) {
                    User user = (User)session.getAttribute("user");
                    if (user.getPriviledgeLevel() != User.PriviledgeLevel.ADMIN) {
                        String listEndpointsURI = request.getContextPath() + "/endpoint";
                        response.sendRedirect(listEndpointsURI);
                        return;
                    }
                    chain.doFilter(request, response);
                } else {
                    chain.doFilter(request, response);
                }
            } else {
                response.sendRedirect(loginURI);
            }
        }
        catch (Throwable t) {
            problem = t;
            t.printStackTrace();
        }
        if (problem != null) {
            if (problem instanceof ServletException) {
                throw (ServletException)problem;
            }
            if (problem instanceof IOException) {
                throw (IOException)problem;
            }
            this.sendProcessingError(problem, response);
        }
    }

    public FilterConfig getFilterConfig() {
        return this.filterConfig;
    }

    public void setFilterConfig(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
    }

    @Override
    public void destroy() {
    }

    @Override
    public void init(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
        if (filterConfig != null) {
            // empty if block
        }
    }

    public String toString() {
        if (this.filterConfig == null) {
            return "LoginFilter()";
        }
        StringBuffer sb = new StringBuffer("LoginFilter(");
        sb.append(this.filterConfig);
        sb.append(")");
        return sb.toString();
    }

    private void sendProcessingError(Throwable t, ServletResponse response) {
        String stackTrace = LoginFilter.getStackTrace(t);
        if (stackTrace != null && !stackTrace.equals("")) {
            try {
                response.setContentType("text/html");
                PrintStream ps = new PrintStream(response.getOutputStream());
                PrintWriter pw = new PrintWriter(ps);
                pw.print("<html>\n<head>\n<title>Error</title>\n</head>\n<body>\n");
                pw.print("<h1>The resource did not process correctly</h1>\n<pre>\n");
                pw.print(stackTrace);
                pw.print("</pre></body>\n</html>");
                pw.close();
                ps.close();
                response.getOutputStream().close();
            }
            catch (Exception ps) {}
        } else {
            try {
                PrintStream ps = new PrintStream(response.getOutputStream());
                t.printStackTrace(ps);
                ps.close();
                response.getOutputStream().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static String getStackTrace(Throwable t) {
        String stackTrace = null;
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            pw.close();
            sw.close();
            stackTrace = sw.getBuffer().toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stackTrace;
    }

    public void log(String msg) {
        this.filterConfig.getServletContext().log(msg);
    }
}

