/*
 * Decompiled with CFR 0.152.
 */
package com.vsiptv.VLite;

import com.vsiptv.VLite.Preset;
import com.vsiptv.VLite.PresetService;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PresetList
implements Serializable {
    private static List<Preset> presetList = new ArrayList<Preset>();

    private PresetList() {
    }

    public static final void clear() {
        presetList.clear();
    }

    public static boolean addPreset(Preset pr) {
        if (pr != null) {
            presetList.add(pr);
            return true;
        }
        return false;
    }

    public static boolean deletePreset(Preset pr) {
        if (pr != null) {
            presetList.remove(pr);
            return true;
        }
        return false;
    }

    public static List<Preset> getInstance() {
        return presetList;
    }

    public static void loadAllPresets(String filename) throws IOException {
        String fullname = filename;
        FileInputStream fileInputStream = new FileInputStream(fullname);
        try (ObjectInputStream objectIntputStream = new ObjectInputStream(fileInputStream);){
            presetList = (List)objectIntputStream.readObject();
            Logger.getLogger(PresetService.class.getName()).log(Level.FINEST, MessageFormat.format("Loading preset file {0}", fullname));
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(PresetService.class.getName()).log(Level.SEVERE, MessageFormat.format("Preset file {0} does not appear to be VLite Presets file", fullname), ex);
        }
    }
}

