/*
 * Decompiled with CFR 0.152.
 */
package com.vsiptv.VLite;

import com.vsiptv.VLite.Endpoint;
import com.vsiptv.VLite.EndpointList;
import com.vsiptv.VLite.EndpointService;
import com.vsiptv.VLite.Preset;
import com.vsiptv.VLite.PresetList;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class PresetService {
    private static final Logger logger = Logger.getLogger(PresetService.class.getName());
    private static boolean presetsLoaded = false;
    private static final boolean DEBUG = true;
    private static final String PRESET_FILENAME_PREFIX = "Presets/VLitePreset";
    private static final String PRESETS_FILENAME = "Presets/VLitePresets";
    private static final Path dir;

    public void saveAllPresets(String filename) throws IOException {
        logger.log(Level.FINEST, "SaveAllPresets");
        FileOutputStream fileOutputStream = new FileOutputStream(filename);
        try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);){
            objectOutputStream.writeObject(PresetList.getInstance());
        }
    }

    public void savePreset(String filename, String presetIndex) throws IOException {
        for (Endpoint ep : EndpointList.getInstance()) {
            logger.log(Level.FINEST, ep.toString());
        }
        FileOutputStream fileOutputStream = new FileOutputStream(filename + "_" + presetIndex);
        try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);){
            objectOutputStream.writeObject(EndpointList.getInstance());
        }
    }

    public void deletePresetByIndex(String filename, String presetIndex) throws IOException {
        File file = new File(filename + "_" + presetIndex);
        Preset pr = Preset.getPresetByIndex(presetIndex);
        PresetList.deletePreset(pr);
        file.delete();
    }

    public void loadPreset(String filename, String presetIndex) throws IOException {
        String fullname = filename + "_" + presetIndex;
        FileInputStream fileInputStream = new FileInputStream(fullname);
        List presetEndpoints = null;
        try {
            ObjectInputStream objectIntputStream = new ObjectInputStream(fileInputStream);
            Iterator iterator = null;
            try {
                presetEndpoints = (List)objectIntputStream.readObject();
            }
            catch (Throwable throwable) {
                iterator = throwable;
                throw throwable;
            }
            finally {
                if (objectIntputStream != null) {
                    if (iterator != null) {
                        try {
                            objectIntputStream.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)((Object)iterator)).addSuppressed(throwable);
                        }
                    } else {
                        objectIntputStream.close();
                    }
                }
            }
        }
        catch (ClassNotFoundException ex) {
            logger.log(Level.SEVERE, MessageFormat.format("Preset file {0} does not appear to be VLite Preset file", fullname), ex);
            return;
        }
        EndpointService endpointService = new EndpointService();
        for (Endpoint ep : presetEndpoints) {
            logger.log(Level.FINEST, ep.toString());
            String epMacAddress = ep.getMacAddress();
            try {
                Endpoint endpoint = endpointService.getEndpointByMacAddress(epMacAddress);
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, MessageFormat.format("Preset file {0} refers to non-existant Endpoint. MacAddress: {1}", fullname, epMacAddress), ex);
                return;
            }
        }
        for (Endpoint epFromPreset : presetEndpoints) {
            String macAddress = epFromPreset.getMacAddress();
            try {
                Endpoint currentEndpoint = endpointService.getEndpointByMacAddress(macAddress);
                if (!currentEndpoint.isDecoder()) continue;
                String sourceEncoderIPAddress = epFromPreset.getStreamHost();
                Endpoint sourceEncoder = endpointService.getEndpointByIPAddress(sourceEncoderIPAddress);
                currentEndpoint.tuneIntoEndpoint(sourceEncoder, epFromPreset.getVwIsActive());
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, MessageFormat.format("Preset file {0} refers to non-existant Endpoint. MacAddress: {1}", fullname, macAddress), ex);
            }
        }
    }

    public List<Preset> getAllPresetsByName() {
        Comparator<Preset> groupByComparator = Comparator.comparing(Preset::getName);
        logger.log(Level.FINEST, MessageFormat.format("getAllPresets{0}", ""));
        List<Preset> result = PresetList.getInstance().stream().sorted(groupByComparator).collect(Collectors.toList());
        PresetList.getInstance().forEach(temp -> logger.log(Level.FINEST, MessageFormat.format("presetList: {0}", temp.getName())));
        return result;
    }

    public List<Preset> getAllPresetsByIndex() {
        if (!presetsLoaded) {
            try {
                logger.log(Level.FINEST, MessageFormat.format("loadAllPreset{0}", "from getAllPresetsByIndex"));
                PresetList.loadAllPresets(PresetService.getPresetsFileName());
                presetsLoaded = true;
            }
            catch (IOException ex) {
                Logger.getLogger(PresetService.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        Comparator<Preset> groupByComparator = Comparator.comparing(Preset::getIndex);
        logger.log(Level.FINEST, MessageFormat.format("getAllPresets{0}", ""));
        List<Preset> result = PresetList.getInstance().stream().sorted(groupByComparator).collect(Collectors.toList());
        PresetList.getInstance().forEach(temp -> logger.log(Level.FINEST, MessageFormat.format("presetList: Index: {0} Name: {1}", temp.getIndex(), temp.getName())));
        return result;
    }

    public static String getPresetFilePrefix() {
        return PRESET_FILENAME_PREFIX;
    }

    public static String getPresetsFileName() {
        return PRESETS_FILENAME;
    }

    static {
        logger.setLevel(Level.FINEST);
        dir = Paths.get("Presets", new String[0]);
        try {
            Files.createDirectory(dir, new FileAttribute[0]);
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
    }
}

