/*
 * Decompiled with CFR 0.152.
 */
package com.vsiptv.VLite;

import com.vsiptv.VLite.Endpoint;
import com.vsiptv.VLite.EndpointService;
import com.vsiptv.VLite.Group;
import com.vsiptv.VLite.MainJFrame;
import com.vsiptv.VLite.NetworkService;
import com.vsiptv.VLite.Preset;
import com.vsiptv.VLite.PresetService;
import com.vsiptv.VLite.User;
import com.vsiptv.VLite.VersionService;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@WebServlet(name="RoutingServlet", urlPatterns={"/routing"})
public class RoutingServlet
extends HttpServlet {
    EndpointService endpointService = new EndpointService();
    PresetService presetService = new PresetService();
    Logger logger = Logger.getLogger(this.getClass().getName());

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String action = req.getParameter("searchAction");
        if (action != null) {
            action.getClass();
        } else {
            this.logger.setLevel(Level.FINEST);
            List<Endpoint> endpoints = this.endpointService.getSortedEndpoints();
            List<Group> displays = this.endpointService.getSortedDisplays();
            List<Preset> presets = this.presetService.getAllPresetsByIndex();
            this.forwardListEndpoints(req, resp, endpoints, displays, presets);
        }
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String action;
        this.logger.setLevel(Level.FINEST);
        switch (action = req.getParameter("action")) {
            case "route": {
                this.logger.log(Level.FINEST, action);
                this.routeEndpointAction(req, resp);
                break;
            }
            case "newPreset": {
                this.logger.log(Level.FINEST, action);
                this.newPresetAction(req, resp);
                break;
            }
            case "savePreset": {
                this.logger.log(Level.FINEST, action);
                this.savePresetAction(req, resp);
                break;
            }
            case "loadPreset": {
                this.logger.log(Level.FINEST, action);
                this.recallPresetAction(req, resp);
                break;
            }
            case "deletePreset": {
                this.logger.log(Level.FINEST, action);
                this.deletePresetAction(req, resp);
            }
        }
    }

    private void routeEndpointAction(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String encoderMac = req.getParameter("encoder");
        String decoderMac = req.getParameter("decoder");
        this.logger.log(Level.FINEST, "Encoder: " + encoderMac + " Decoder: " + decoderMac);
        try {
            Group display = this.endpointService.getDisplayByUniqueName(decoderMac);
            Endpoint source = this.endpointService.getEndpointByMacAddress(encoderMac);
            this.logger.log(Level.FINEST, "Encoder: " + source.toString() + " Decoder: " + display.toString());
            display.tuneIntoEndpoint(source, false);
        }
        catch (Exception ex) {
            System.out.println("Exception: " + ex);
        }
        String result = "Tuning endpoint " + decoderMac + " into endpoint " + encoderMac;
        this.forwardRouting(req, resp, result);
    }

    private void newPresetAction(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String pIndex = req.getParameter("presetindex");
        String pName = req.getParameter("presetname");
        Preset test = Preset.createOrGetPreset(pIndex, pName);
        test.setName(pName);
        this.presetService.savePreset(PresetService.getPresetFilePrefix(), pIndex);
        this.presetService.saveAllPresets(PresetService.getPresetsFileName());
        this.logger.log(Level.FINEST, MessageFormat.format("Index: {0} Name: {1} Preset: {2}", pIndex, pName, test.getName()));
    }

    private void savePresetAction(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String pIndex = req.getParameter("presetindex");
        this.presetService.savePreset(PresetService.getPresetFilePrefix(), pIndex);
        this.presetService.saveAllPresets(PresetService.getPresetsFileName());
    }

    private void recallPresetAction(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String pIndex = req.getParameter("presetindex");
        this.presetService.loadPreset(PresetService.getPresetFilePrefix(), pIndex);
    }

    private void deletePresetAction(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String pIndex = req.getParameter("presetindex");
        Preset test = Preset.getPresetByIndex(pIndex);
        this.presetService.deletePresetByIndex(PresetService.getPresetFilePrefix(), pIndex);
        this.presetService.saveAllPresets(PresetService.getPresetsFileName());
        this.logger.log(Level.FINEST, MessageFormat.format("Delete Preset Index: {0}", pIndex));
    }

    private void forwardListEndpoints(HttpServletRequest req, HttpServletResponse resp, List endpointList, List displayList, List presetList) throws ServletException, IOException {
        String nextJSP = "/jsp/routing.jsp";
        req.setAttribute("loggedInUser", User.getLoggedInUser().getName());
        req.setAttribute("pString", MainJFrame.productString);
        req.setAttribute("vString", VersionService.getServerVersion());
        req.setAttribute("sString", NetworkService.getSelectedHostAddress());
        req.setAttribute("websiteString", MainJFrame.websiteString);
        req.setAttribute("imageString", MainJFrame.imageString);
        req.setAttribute("password", MainJFrame.PASSWORD);
        req.setAttribute("endpointList", endpointList);
        req.setAttribute("displayList", displayList);
        req.setAttribute("presetList", presetList);
        RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher(nextJSP);
        dispatcher.forward(req, resp);
    }

    private void forwardRouting(HttpServletRequest req, HttpServletResponse resp, String result) throws ServletException, IOException {
        String nextJSP = "/jsp/routing.jsp";
        req.setAttribute("loggedInUser", User.getLoggedInUser().getName());
        req.setAttribute("pString", MainJFrame.productString);
        req.setAttribute("websiteString", MainJFrame.websiteString);
        req.setAttribute("imageString", MainJFrame.imageString);
        req.setAttribute("password", MainJFrame.PASSWORD);
        req.setAttribute("text", result);
        RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher(nextJSP);
        dispatcher.forward(req, resp);
    }
}

