/*
 * Decompiled with CFR 0.152.
 */
package com.vsiptv.VLite;

import com.vsiptv.VLite.Endpoint;
import com.vsiptv.VLite.Group;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public class VideoWall
extends Group {
    private final List<Endpoint> endpointList = new ArrayList<Endpoint>();

    public static Group createOrGetGroup(String groupName) {
        Group group = Group.getGroupByName(groupName);
        if (group == null) {
            group = new VideoWall(groupName){};
        }
        LOGS.log(Level.FINEST, MessageFormat.format("Group name: {0}", group));
        return group;
    }

    public VideoWall(String groupName) {
        super(groupName);
        this.setCanHaveChildren(false);
    }

    public List<Endpoint> getEndpointList() {
        return this.endpointList;
    }

    public void addEndpoint(Endpoint endpoint) {
        this.endpointList.add(endpoint);
    }

    @Override
    public void tuneIntoEndpoint(Endpoint source, Boolean vwActive) {
        for (Endpoint ep : this.endpointList) {
            new Thread(() -> ep.tuneIntoEndpoint(source, true)).start();
        }
    }

    @Override
    public Boolean isDisplay() {
        return true;
    }

    public String getIpAddress() {
        return this.endpointList.get(0).getIpAddress();
    }
}

