/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.util.ServerInfo;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public class VersionLoggerListener
implements LifecycleListener {
    private static final Log log = LogFactory.getLog(VersionLoggerListener.class);
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.startup");
    private boolean logArgs = true;
    private boolean logEnv = false;

    public boolean getLogArgs() {
        return this.logArgs;
    }

    public void setLogArgs(boolean logArgs) {
        this.logArgs = logArgs;
    }

    public boolean getLogEnv() {
        return this.logEnv;
    }

    public void setLogEnv(boolean logEnv) {
        this.logEnv = logEnv;
    }

    @Override
    public void lifecycleEvent(LifecycleEvent event) {
        if ("before_init".equals(event.getType())) {
            this.log();
        }
    }

    private void log() {
        log.info(sm.getString("versionLoggerListener.serverInfo.server.version", ServerInfo.getServerInfo()));
        log.info(sm.getString("versionLoggerListener.serverInfo.server.built", ServerInfo.getServerBuilt()));
        log.info(sm.getString("versionLoggerListener.serverInfo.server.number", ServerInfo.getServerNumber()));
        log.info(sm.getString("versionLoggerListener.os.name", System.getProperty("os.name")));
        log.info(sm.getString("versionLoggerListener.os.version", System.getProperty("os.version")));
        log.info(sm.getString("versionLoggerListener.os.arch", System.getProperty("os.arch")));
        log.info(sm.getString("versionLoggerListener.java.home", System.getProperty("java.home")));
        log.info(sm.getString("versionLoggerListener.vm.version", System.getProperty("java.runtime.version")));
        log.info(sm.getString("versionLoggerListener.vm.vendor", System.getProperty("java.vm.vendor")));
        log.info(sm.getString("versionLoggerListener.catalina.base", System.getProperty("catalina.base")));
        log.info(sm.getString("versionLoggerListener.catalina.home", System.getProperty("catalina.home")));
        if (this.logArgs) {
            List<String> args = ManagementFactory.getRuntimeMXBean().getInputArguments();
            for (String arg : args) {
                log.info(sm.getString("versionLoggerListener.arg", arg));
            }
        }
        if (this.logEnv) {
            Map<String, String> envs = System.getenv();
            TreeSet<String> keys = new TreeSet<String>(envs.keySet());
            for (String key : keys) {
                log.info(sm.getString("versionLoggerListener.env", key, envs.get(key)));
            }
        }
    }
}

