/*
 * Decompiled with CFR 0.152.
 */
package com.vsiptv.VLite;

import com.vsiptv.VLite.NetworkService;
import com.vsiptv.VLite.PasswordTextGUI;
import com.vsiptv.VLite.PortTextGUI;
import com.vsiptv.VLite.VersionService;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Calendar;
import java.util.List;
import java.util.Optional;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.startup.Tomcat;
import org.apache.commons.io.FileUtils;

public class MainJFrame
extends JFrame
implements ClipboardOwner {
    Logger logger = Logger.getLogger(this.getClass().getName());
    private static Tomcat tomcat;
    private static ExecutorService executor;
    public static String PORT;
    public static String PASSWORD;
    public static final Optional<String> HOSTNAME;
    public static final String MFG = "Visionary";
    public static String copyRightString;
    public static String companyString;
    public static String productString;
    public static String websiteString;
    public static String imageString;
    public static String buildDate;
    private ButtonGroup buttonGroup1;
    private JMenuItem exitMenuItem;
    private JMenuItem jCopyMenuItem;
    private JMenu jEditMenu;
    public static JEditorPane jEditorPane;
    private JMenu jMenu1;
    private JMenuBar jMenuBar1;
    private JMenu jNetIntMenu;
    private JMenu jPasswordMenu1;
    private JMenuItem jPasswordMenuItem1;
    private JMenu jPortMenu;
    private JMenuItem jPortMenuItem;
    private JScrollPane jScrollPane1;

    public MainJFrame() {
        this.logger.setLevel(Level.FINEST);
        this.logger.log(Level.FINEST, "enter method");
        this.initComponents();
        buildDate = this.getBuildDate("/META-INF/resources/build_date.txt");
        this.logger.log(Level.FINEST, "BuildDate: {0}", buildDate);
        this.setOemId();
        PORT = MainJFrame.getPort();
        this.logger.log(Level.FINEST, "Port: {0}", PORT);
        PASSWORD = MainJFrame.getPassword();
        this.logger.log(Level.FINEST, "Password: {0}", PASSWORD);
        this.setTitle(productString + " Server");
        this.updateComponents();
        this.setSize(800, 500);
        this.setLocationRelativeTo(null);
        this.setIconImage(this.createImage("/META-INF/resources/images/" + imageString).getImage());
        jEditorPane.setText(this.getSplashPageHTML());
        jEditorPane.setCaretPosition(0);
        int docLength = jEditorPane.getDocument().getLength();
        jEditorPane.select(docLength - 37, docLength);
        this.logger.log(Level.FINEST, "returning from MainJFrame.<init>");
    }

    private int setOemId() {
        if (MFG.equals("OEM")) {
            copyRightString = "Copyright&copy " + this.getBuildYear() + " All Rights Reserved.";
            companyString = "OEM";
            productString = "VLite-OEM";
            websiteString = "www.vsicam.com";
            imageString = "vision.png";
        } else {
            copyRightString = "Copyright&copy " + this.getBuildYear() + " Visionary Solutions, Inc. All Rights Reserved.";
            companyString = "Visionary Solutions, Inc.";
            productString = "Vision Lite";
            websiteString = "www.vsicam.com";
            imageString = "vision.png";
        }
        return 0;
    }

    public static String getPort() {
        String portFileOnDisk = "Presets/port.txt";
        try {
            String port = FileUtils.readFileToString(new File(portFileOnDisk));
            return port;
        }
        catch (IOException ex) {
            Logger.getLogger(PortTextGUI.class.getName()).log(Level.SEVERE, null, ex);
            return "8080";
        }
    }

    public static String getPassword() {
        String passwordFileOnDisk = "Presets/password.txt";
        try {
            String password = FileUtils.readFileToString(new File(passwordFileOnDisk));
            return password;
        }
        catch (IOException ex) {
            Logger.getLogger(PortTextGUI.class.getName()).log(Level.SEVERE, null, ex);
            return "admin";
        }
    }

    private String getSplashPageHTML() {
        String html = null;
        try {
            String read;
            InputStream in = this.getClass().getResourceAsStream("README.html");
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            StringBuilder text = new StringBuilder();
            String serverIP = NetworkService.getSelectedHostAddress();
            Calendar dcal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            dcal.clear();
            dcal.set(1995, 3, 4);
            long dtime = (System.currentTimeMillis() - dcal.getTimeInMillis()) / 60000L;
            while ((read = br.readLine()) != null) {
                if (read.endsWith("</body>")) {
                    text.append("<div><h1>" + companyString + " " + productString + " PacketAV&reg Server</h1>");
                    text.append("<p> Allows AV over IP drag and drop routing and live thumbnails.<br>");
                    text.append(copyRightString + "<br>" + websiteString + "</p><br></div>");
                    text.append("<div><p>Please note that to connect to the application from other computers you would need to browse to http://" + serverIP + ":" + PORT + "</p></div>");
                    text.append("<div><p>" + productString + " Version: " + VersionService.getServerVersion() + "-" + dtime + "<br>");
                    text.append("Build Date: " + buildDate + "<br>");
                    text.append("Encoder Firmware Version: " + VersionService.getEncoder_fw_version() + "<br>");
                    text.append("Decoder Firmware Version: " + VersionService.getDecoder_fw_version() + "<br>");
                    text.append("</p></div>");
                }
                text.append(read);
            }
            html = text.toString();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return html;
    }

    private void launchServer() {
        this.logger.log(Level.FINEST, Thread.currentThread().getStackTrace()[1].toString());
        String threadName = Thread.currentThread().getName();
        this.logger.log(Level.FINEST, "Thread: {0} method: {1}", new Object[]{threadName, Thread.currentThread().getStackTrace()[1].getMethodName()});
        tomcat = new Tomcat();
        executor = Executors.newSingleThreadExecutor();
        executor.submit(() -> {
            try {
                String contextPath = "/";
                String appBase = ".";
                tomcat.setPort(Integer.valueOf(PORT));
                tomcat.setHostname(HOSTNAME.orElse("localhost"));
                tomcat.getHost().setAppBase(appBase);
                tomcat.addWebapp(contextPath, appBase);
                tomcat.start();
                tomcat.getServer().await();
            }
            catch (ServletException | LifecycleException ex) {
                Logger.getLogger(MainJFrame.class.getName()).log(Level.SEVERE, null, ex);
            }
        });
        this.logger.log(Level.FINEST, "exiting LICENSE_VALID case");
    }

    private static void setLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception ex) {
            Logger.getLogger(MainJFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void updateComponents() {
        List<String> networkInterfaceNameList = null;
        try {
            networkInterfaceNameList = NetworkService.discoverNetworkInterfaces();
        }
        catch (Exception ex) {
            this.logger.log(Level.SEVERE, "No Network Interfaces found: " + ex.toString());
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        for (String networkInterfaceName : networkInterfaceNameList) {
            JRadioButtonMenuItem menuItem = new JRadioButtonMenuItem();
            menuItem.setText(networkInterfaceName);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    MainJFrame.this.networkInterfaceMenuItemActionPerformed(evt);
                }
            });
            buttonGroup.add(menuItem);
            this.jNetIntMenu.add(menuItem);
            menuItem.setSelected(true);
        }
        this.jNetIntMenu.updateUI();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jScrollPane1 = new JScrollPane();
        jEditorPane = new JEditorPane();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.exitMenuItem = new JMenuItem();
        this.jEditMenu = new JMenu();
        this.jCopyMenuItem = new JMenuItem();
        this.jNetIntMenu = new JMenu();
        this.jPortMenu = new JMenu();
        this.jPortMenuItem = new JMenuItem();
        this.jPasswordMenu1 = new JMenu();
        this.jPasswordMenuItem1 = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.setTitle("Vision Lite Server");
        this.setIconImages(null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent evt) {
                MainJFrame.this.formWindowOpened(evt);
            }
        });
        jEditorPane.setEditable(false);
        jEditorPane.setContentType("text/html");
        this.jScrollPane1.setViewportView(jEditorPane);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.jMenu1.setText("File");
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainJFrame.this.exitMenuItemActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.exitMenuItem);
        this.jMenuBar1.add(this.jMenu1);
        this.jEditMenu.setText("Edit");
        this.jCopyMenuItem.setText("Copy");
        this.jCopyMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainJFrame.this.jCopyMenuItemActionPerformed(evt);
            }
        });
        this.jEditMenu.add(this.jCopyMenuItem);
        this.jMenuBar1.add(this.jEditMenu);
        this.jNetIntMenu.setText("Network Interface");
        this.jMenuBar1.add(this.jNetIntMenu);
        this.jPortMenu.setText("Port");
        this.jPortMenuItem.setText("Port");
        this.jPortMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainJFrame.this.jPortMenuItemActionPerformed(evt);
            }
        });
        this.jPortMenu.add(this.jPortMenuItem);
        this.jMenuBar1.add(this.jPortMenu);
        this.jPasswordMenu1.setText("Password");
        this.jPasswordMenuItem1.setText("Password");
        this.jPasswordMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainJFrame.this.jPasswordMenuItem1ActionPerformed(evt);
            }
        });
        this.jPasswordMenu1.add(this.jPasswordMenuItem1);
        this.jMenuBar1.add(this.jPasswordMenu1);
        this.setJMenuBar(this.jMenuBar1);
        this.pack();
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void networkInterfaceMenuItemActionPerformed(ActionEvent evt) {
        this.logger.log(Level.INFO, "Network Interface selected: {0}", evt.getActionCommand());
        String find = NetworkService.getSelectedHostAddress();
        JMenuItem selectedMenuItem = (JMenuItem)evt.getSource();
        JPopupMenu menu = (JPopupMenu)selectedMenuItem.getParent();
        int index = menu.getComponentIndex(selectedMenuItem);
        try {
            NetworkService.selectNetworkInterfaceWithIndex(index);
        }
        catch (IOException ex) {
            Logger.getLogger(MainJFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        String replace = NetworkService.getSelectedHostAddress();
        Document doc = jEditorPane.getDocument();
        try {
            for (int pos = 0; pos < doc.getLength() - find.length(); ++pos) {
                String text = doc.getText(pos, find.length());
                if (!find.equals(text)) continue;
                doc.remove(pos, find.length());
                doc.insertString(pos, replace, null);
                break;
            }
        }
        catch (BadLocationException ex) {
            this.logger.log(Level.SEVERE, "Could not update splash page with new network interface IP address: {0}", ex.toString());
        }
    }

    private void formWindowOpened(WindowEvent evt) {
        this.launchServer();
    }

    private void jCopyMenuItemActionPerformed(ActionEvent evt) {
        this.logger.log(Level.FINEST, Thread.currentThread().getStackTrace()[1].toString());
        StringSelection selectedString = new StringSelection(jEditorPane.getSelectedText());
        Clipboard systemClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        systemClipboard.setContents(selectedString, this);
    }

    private void jPortMenuItemActionPerformed(ActionEvent evt) {
        new PortTextGUI((Frame)this, true).setVisible(true);
    }

    private void jPasswordMenuItem1ActionPerformed(ActionEvent evt) {
        new PasswordTextGUI((Frame)this, true).setVisible(true);
    }

    public static void main(String[] args) throws LifecycleException {
        MainJFrame.setLookAndFeel();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MainJFrame().setVisible(true);
            }
        });
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    public ImageIcon createImage(String path) {
        this.logger.log(Level.FINEST, "Path is {0}", path);
        URL imgURL = this.getClass().getResource(path);
        this.logger.log(Level.FINEST, "URL is {0}", imgURL);
        return new ImageIcon(imgURL);
    }

    private String getBuildDate(String path) {
        InputStream ins = MainJFrame.class.getResourceAsStream(path);
        BufferedReader br = new BufferedReader(new InputStreamReader(ins));
        try {
            String line = br.readLine();
            this.logger.log(Level.FINEST, "Line: {0}", line);
            String[] bd = line.split("=");
            this.logger.log(Level.FINEST, "BuildDate: {0}", bd[1]);
            return bd[1];
        }
        catch (IOException ex) {
            Logger.getLogger(MainJFrame.class.getName()).log(Level.SEVERE, null, ex);
            return "NA";
        }
    }

    private String getBuildYear() {
        String[] by = buildDate.split("-");
        return by[0];
    }

    static {
        HOSTNAME = Optional.ofNullable(System.getenv("HOSTNAME"));
    }
}

