/*
 * Decompiled with CFR 0.152.
 */
package com.vsiptv.VLite;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SealedObject;
import javax.crypto.SecretKey;

public class User
implements Serializable {
    private static final Logger logger = Logger.getLogger("User");
    private static final Map<String, User> users = new HashMap<String, User>();
    private static User loggedInUser;
    private String name;
    private String password;
    private PriviledgeLevel priviledgeLevel;

    public static User getUserByName(String userName) {
        return users.get(userName);
    }

    public static User getLoggedInUser() {
        return loggedInUser;
    }

    public static PriviledgeLevel getLoggedInUserPriviledgeLevel() {
        if (loggedInUser != null) {
            return loggedInUser.getPriviledgeLevel();
        }
        return PriviledgeLevel.NONE;
    }

    public static void login(String username, String password) {
        User new_user = users.getOrDefault(username, null);
        if (new_user != null && new_user.getPassword().equals(password)) {
            loggedInUser = new_user;
        }
    }

    public static void logout() {
        loggedInUser = null;
    }

    public static User createInstance(String user, String pass, PriviledgeLevel level) {
        logger.log(Level.FINEST, "user {0}, pass {1}, level {2}", new Object[]{user, pass, level});
        User new_user = new User(user, pass, level);
        logger.log(Level.FINEST, "new User: {0} users: ", new Object[]{new_user, users});
        users.putIfAbsent(user, new_user);
        return new_user;
    }

    private User(String user, String pass, PriviledgeLevel level) {
        this.name = user;
        this.password = pass;
        this.priviledgeLevel = level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(String filename) {
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(filename);
            ObjectOutputStream oos = new ObjectOutputStream(fout);
            KeyGenerator keyGen = KeyGenerator.getInstance("AES");
            SecretKey secretKeyOnServer = keyGen.generateKey();
            Cipher cipher = Cipher.getInstance("AES");
            oos.writeObject(new SealedObject((Serializable)((Object)users), cipher));
        }
        catch (FileNotFoundException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        catch (NoSuchAlgorithmException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        catch (NoSuchPaddingException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        catch (IllegalBlockSizeException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                fout.close();
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }
    }

    public static void read(String filename) {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public PriviledgeLevel getPriviledgeLevel() {
        return this.priviledgeLevel;
    }

    public void setPriviledgeLevel(PriviledgeLevel priviledgeLevel) {
        this.priviledgeLevel = priviledgeLevel;
    }

    static {
        User admin = User.createInstance("admin", "admin", PriviledgeLevel.ADMIN);
        User user1 = User.createInstance("user1", "user1", PriviledgeLevel.USER);
        User user = User.createInstance("user2", "user2", PriviledgeLevel.USER);
        loggedInUser = null;
    }

    public static enum PriviledgeLevel {
        ADMIN(0),
        USER(1),
        NONE(2);

        private final int level;

        private int level() {
            return this.level;
        }

        private PriviledgeLevel(int level) {
            this.level = level;
        }
    }
}

