/*
 * Decompiled with CFR 0.152.
 */
package com.vsiptv.VLite;

import com.vsiptv.VLite.Endpoint;
import com.vsiptv.VLite.EndpointList;
import com.vsiptv.VLite.MainJFrame;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;

public class VersionService {
    private static final Logger logger = Logger.getLogger("VersionService");
    private static final Boolean DEBUG = false;
    private static final String FW_PATH = "META-INF/resources/binaries/";
    private static final String FW_D_NAME = "D4000_web.d4000";
    private static final String FW_E_NAME = "E4000_web.e4000";
    private static String decoder_fw_version;
    private static String encoder_fw_version;

    public static String getServerVersion() {
        String temp = VersionService.getEncoder_fw_version();
        logger.log(Level.FINEST, "ServerVersion: {0}", temp);
        return temp;
    }

    public static String getDecoder_fw_version() {
        if (decoder_fw_version == null) {
            try {
                VersionService.setFWVersions();
            }
            catch (IOException | URISyntaxException ex) {
                Logger.getLogger(VersionService.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return decoder_fw_version;
    }

    public static String getEncoder_fw_version() {
        if (encoder_fw_version == null) {
            try {
                VersionService.setFWVersions();
            }
            catch (IOException | URISyntaxException ex) {
                Logger.getLogger(VersionService.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return encoder_fw_version;
    }

    public static void setFWVersions() throws URISyntaxException, IOException {
        String jarPath = MainJFrame.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
        if (DEBUG.booleanValue()) {
            logger.log(Level.FINEST, "JAR location: {0}", jarPath);
        }
        try {
            JarFile jarFile = new JarFile(jarPath);
            Enumeration<JarEntry> jarEnum = jarFile.entries();
            block10: while (jarEnum.hasMoreElements()) {
                JarEntry je = jarEnum.nextElement();
                switch (je.getName()) {
                    case "META-INF/resources/binaries/D4000_web.d4000": {
                        decoder_fw_version = VersionService.extractFWVersionFromJarEntry(je, jarFile);
                        continue block10;
                    }
                    case "META-INF/resources/binaries/E4000_web.e4000": {
                        encoder_fw_version = VersionService.extractFWVersionFromJarEntry(je, jarFile);
                        continue block10;
                    }
                }
            }
        }
        catch (IOException ex) {
            Logger.getLogger(VersionService.class.getName()).log(Level.SEVERE, null, ex);
        }
        logger.log(Level.FINEST, "Encoder FW version: {0}", encoder_fw_version);
        logger.log(Level.FINEST, "Decoder FW version: {0}", decoder_fw_version);
    }

    private static String extractFWVersionFromJarEntry(JarEntry je, JarFile jarFile) throws IOException {
        String versionString = "0.0.1";
        try (TarArchiveInputStream tarInput = new TarArchiveInputStream(new GzipCompressorInputStream(jarFile.getInputStream(je)));){
            TarArchiveEntry tarEntry = tarInput.getNextTarEntry();
            while (tarEntry != null) {
                if (tarEntry.getName().endsWith("visionary_tag")) {
                    if (DEBUG.booleanValue()) {
                        logger.log(Level.FINEST, "FOUND tarEntry: {0}", tarEntry.getName());
                    }
                    try (BufferedReader br = new BufferedReader(new InputStreamReader(tarInput));){
                        versionString = br.readLine();
                        break;
                    }
                }
                tarEntry = tarInput.getNextTarEntry();
            }
        }
        return versionString;
    }

    public static String getUpdateMessage() {
        return MessageFormat.format("Device firmware can be updated. Latest firmware versions are encoder: {0};  decoder: {1}", VersionService.getEncoder_fw_version(), VersionService.getDecoder_fw_version());
    }

    public static Boolean firmwareUpdatePossible() {
        DefaultArtifactVersion decoderFWVersion = new DefaultArtifactVersion(VersionService.getDecoder_fw_version());
        DefaultArtifactVersion encoderFWVersion = new DefaultArtifactVersion(VersionService.getEncoder_fw_version());
        for (Endpoint ep : EndpointList.getInstance()) {
            DefaultArtifactVersion epFWVersion = new DefaultArtifactVersion(ep.getFwVersion());
            if (ep.isDecoder() && epFWVersion.compareTo(decoderFWVersion) < 0) {
                if (DEBUG.booleanValue()) {
                    logger.log(Level.FINEST, MessageFormat.format("firmwareUpdatePossible: {0}, decoderFWVersion: {1}, serverFWVersion: {2}", true, ep.getFwVersion(), VersionService.getDecoder_fw_version()));
                }
                return true;
            }
            if (!ep.isEncoder() || epFWVersion.compareTo(encoderFWVersion) >= 0) continue;
            if (DEBUG.booleanValue()) {
                logger.log(Level.FINEST, MessageFormat.format("firmwareUpdatePossible: {0}, encoderFWVersion: {1}, serverFWVersion: {2}", true, ep.getFwVersion(), VersionService.getEncoder_fw_version()));
            }
            return true;
        }
        return false;
    }

    static {
        logger.setLevel(Level.FINEST);
        decoder_fw_version = null;
        encoder_fw_version = null;
    }
}

