/*
 * Decompiled with CFR 0.152.
 */
package com.vsiptv.VLite;

import com.vsiptv.VLite.Endpoint;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class Group
implements Iterable<Group> {
    static final Logger LOGS = Logger.getLogger(Group.class.getName());
    private static final List<Group> groupList = new ArrayList<Group>();
    private static final Map<String, Group> groupsByName = new HashMap<String, Group>();
    private String name;
    private List<Group> parents;
    private List<Group> children;
    private Boolean canHaveChildren;

    public static List<Group> getGroupList() {
        return groupList;
    }

    public static Group getGroupByName(String groupName) {
        return groupsByName.getOrDefault(groupName, null);
    }

    public static final void clear() {
        groupList.clear();
        groupsByName.clear();
    }

    public static Group createOrGetGroup(String groupName) {
        Group group = Group.getGroupByName(groupName);
        if ("".equals(groupName)) {
            return null;
        }
        if (group == null) {
            group = new Group(groupName){};
        }
        LOGS.log(Level.FINEST, MessageFormat.format("Group name: {0}", group));
        return group;
    }

    public Group(String groupName) {
        this.name = groupName;
        this.children = new ArrayList<Group>(){};
        this.parents = new ArrayList<Group>(){};
        this.canHaveChildren = true;
        groupList.add(this);
        groupsByName.put(groupName, this);
    }

    public Group() {
    }

    public Boolean getCanHaveChildren() {
        return this.canHaveChildren;
    }

    public final void setCanHaveChildren(Boolean canHaveChildren) {
        this.canHaveChildren = canHaveChildren;
    }

    public void addChild(Group child) {
        if (this.canHaveChildren.booleanValue()) {
            if (!this.children.contains(child)) {
                this.children.add(child);
                child.parents.add(this);
            } else {
                LOGS.log(Level.FINEST, MessageFormat.format("Group {0} already has group {1} as child", this.getName(), child.getName()));
            }
        } else {
            LOGS.log(Level.FINEST, MessageFormat.format("Object {0} cannot have children", this.getName()));
        }
    }

    public void addParent(Group parent) {
        if (!this.parents.contains(parent)) {
            this.parents.add(parent);
            parent.children.add(this);
        } else {
            LOGS.log(Level.FINEST, MessageFormat.format("Group {0} already has group {1} as parent", this.getName(), parent.getName()));
        }
    }

    public String getDisplayName() {
        return "Video Wall: " + this.name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Group> getChildren() {
        return this.children;
    }

    public List<Group> getParents() {
        return this.parents;
    }

    public void tuneIntoEndpoint(Endpoint source, Boolean vwActive) {
        this.getChildren().stream().forEach(g -> g.tuneIntoEndpoint(source, false));
    }

    public Boolean isDisplay() {
        return false;
    }

    public String toString() {
        return "Group{ name=" + this.getName() != null ? this.getName() : ("<name is null>, parent=" + this.parents != null ? MessageFormat.format("{0} parents", this.parents.size()) : ("<parents is null>, children=" + this.children != null ? MessageFormat.format("{0} children", this.children.size()) : "<groups is null>}"));
    }

    @Override
    public Iterator<Group> iterator() {
        TreeNodeIter iter = new TreeNodeIter(this);
        return iter;
    }

    static {
        Group group1 = new Group("Group 1"){};
        Group group2 = new Group("Group 2"){};
        Group group11 = new Group("Group 1.1"){};
        Group group12 = new Group("Group 1.2"){};
        group1.addChild(group11);
        group1.addChild(group12);
    }

    static class TreeNodeIter
    implements Iterator<Group> {
        private Group treeNode;
        private ProcessStages doNext;
        private Group next;
        private Iterator<Group> childrenCurNodeIter;
        private Iterator<Group> childrenSubNodeIter;

        public TreeNodeIter(Group treeNode) {
            this.treeNode = treeNode;
            this.doNext = ProcessStages.ProcessParent;
            this.childrenCurNodeIter = treeNode.children.iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.doNext == ProcessStages.ProcessParent) {
                this.next = this.treeNode;
                this.doNext = ProcessStages.ProcessChildCurNode;
                return true;
            }
            if (this.doNext == ProcessStages.ProcessChildCurNode) {
                if (this.childrenCurNodeIter.hasNext()) {
                    Group childDirect = this.childrenCurNodeIter.next();
                    this.childrenSubNodeIter = childDirect.iterator();
                    this.doNext = ProcessStages.ProcessChildSubNode;
                    return this.hasNext();
                }
                this.doNext = null;
                return false;
            }
            if (this.doNext == ProcessStages.ProcessChildSubNode) {
                if (this.childrenSubNodeIter.hasNext()) {
                    this.next = this.childrenSubNodeIter.next();
                    return true;
                }
                this.next = null;
                this.doNext = ProcessStages.ProcessChildCurNode;
                return this.hasNext();
            }
            return false;
        }

        @Override
        public Group next() {
            return this.next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        static enum ProcessStages {
            ProcessParent,
            ProcessChildCurNode,
            ProcessChildSubNode;

        }
    }
}

