/*
 * Decompiled with CFR 0.152.
 */
package com.vsiptv.VLite;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class NetworkService {
    private static final Logger logger = Logger.getLogger("NetworkService");
    private static final Boolean debug = false;
    private static final List<NIPair> networkInterfaceList;
    private static NIPair selectedNetworkInterface;
    private static String selectedHostAddress;

    public static List<NIPair> getNetworkInterfaceList() {
        return networkInterfaceList;
    }

    public static List<String> getNetworkInterfaceNamesForMenu() {
        return networkInterfaceList.stream().map(nip -> MessageFormat.format("{0} {1}", nip.getNetworkInterface().getDisplayName(), ((InetAddress)nip.getInetAddress()).getHostAddress())).collect(Collectors.toList());
    }

    public static NIPair getSelectedNetworkInterface() {
        return selectedNetworkInterface;
    }

    public static String getSelectedHostAddress() {
        return selectedHostAddress;
    }

    public static List<String> discoverNetworkInterfaces() throws SocketException {
        Enumeration<NetworkInterface> netIntEnum = NetworkInterface.getNetworkInterfaces();
        int loop = 0;
        while (netIntEnum.hasMoreElements() && loop < 10) {
            NetworkInterface networkInterface = netIntEnum.nextElement();
            if (debug.booleanValue()) {
                logger.log(Level.FINEST, MessageFormat.format("Found NetworkInterface {0} with displayName {1}", networkInterface, networkInterface.getDisplayName()));
            }
            if (!networkInterface.isUp() || networkInterface.isLoopback() || networkInterface.isVirtual()) {
                if (!debug.booleanValue()) continue;
                logger.log(Level.FINEST, MessageFormat.format("Filtering NetworkInterface {0} with displayName {1} ()", networkInterface, networkInterface.getDisplayName()));
                continue;
            }
            Enumeration<InetAddress> inetAddrEnum = networkInterface.getInetAddresses();
            while (inetAddrEnum.hasMoreElements() && loop < 10) {
                InetAddress inetAddr = inetAddrEnum.nextElement();
                if (!(inetAddr instanceof Inet4Address)) continue;
                logger.log(Level.FINEST, MessageFormat.format("Adding NetworkInterface {0} with HostAddress {1}", networkInterface, inetAddr.getHostAddress()));
                NIPair nip = new NIPair(networkInterface, inetAddr);
                networkInterfaceList.add(nip);
                ++loop;
                selectedNetworkInterface = nip;
                selectedHostAddress = inetAddr.getHostAddress();
            }
        }
        return NetworkService.getNetworkInterfaceNamesForMenu();
    }

    public static void selectNetworkInterfaceWithIndex(int index) throws IOException {
        logger.log(Level.FINEST, "Selecting NetworkInterface with Index: {0}", index);
        selectedNetworkInterface = networkInterfaceList.get(index);
        selectedHostAddress = ((InetAddress)selectedNetworkInterface.getInetAddress()).getHostAddress();
        NetworkService.saveNetworkInterface(selectedHostAddress);
    }

    public static void saveNetworkInterface(String iface) throws IOException {
        String filename = "Presets/Interface";
        FileOutputStream fileOutputStream = new FileOutputStream(filename);
        try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);){
            objectOutputStream.writeObject(iface);
        }
    }

    public void loadNetworkInterface(String filename) throws IOException {
        String fullname = "Presets/Interface";
        FileInputStream fileInputStream = new FileInputStream(fullname);
        String iface = null;
        try (ObjectInputStream objectIntputStream = new ObjectInputStream(fileInputStream);){
            iface = (String)objectIntputStream.readObject();
        }
        catch (ClassNotFoundException ex) {
            logger.log(Level.SEVERE, MessageFormat.format("Network Interface file {0} does not appear to be valid.", fullname), ex);
            return;
        }
    }

    static {
        logger.setLevel(Level.FINEST);
        networkInterfaceList = new ArrayList<NIPair>();
    }

    public static class NIPair<NetworkAddress, InetAddress> {
        private final NetworkInterface networkInterface;
        private final InetAddress inetAddress;

        public NIPair(NetworkInterface ni, InetAddress ia) {
            this.networkInterface = ni;
            this.inetAddress = ia;
        }

        public NetworkInterface getNetworkInterface() {
            return this.networkInterface;
        }

        public InetAddress getInetAddress() {
            return this.inetAddress;
        }

        public int hashCode() {
            return this.networkInterface.hashCode() ^ this.inetAddress.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NIPair other = (NIPair)obj;
            if (!Objects.equals(this.networkInterface, other.networkInterface)) {
                return false;
            }
            return Objects.equals(this.inetAddress, other.inetAddress);
        }
    }
}

