/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import java.io.File;
import java.io.IOException;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Globals;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Realm;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.connector.Request;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.startup.Bootstrap;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.codec.binary.Base64;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.Oid;

public class SpnegoAuthenticator
extends AuthenticatorBase {
    private static final Log log = LogFactory.getLog(SpnegoAuthenticator.class);
    private String loginConfigName = "com.sun.security.jgss.krb5.accept";
    private boolean storeDelegatedCredential = true;
    private Pattern noKeepAliveUserAgents = null;

    public String getLoginConfigName() {
        return this.loginConfigName;
    }

    public void setLoginConfigName(String loginConfigName) {
        this.loginConfigName = loginConfigName;
    }

    public boolean isStoreDelegatedCredential() {
        return this.storeDelegatedCredential;
    }

    public void setStoreDelegatedCredential(boolean storeDelegatedCredential) {
        this.storeDelegatedCredential = storeDelegatedCredential;
    }

    public String getNoKeepAliveUserAgents() {
        Pattern p = this.noKeepAliveUserAgents;
        if (p == null) {
            return null;
        }
        return p.pattern();
    }

    public void setNoKeepAliveUserAgents(String noKeepAliveUserAgents) {
        this.noKeepAliveUserAgents = noKeepAliveUserAgents == null || noKeepAliveUserAgents.length() == 0 ? null : Pattern.compile(noKeepAliveUserAgents);
    }

    @Override
    protected String getAuthMethod() {
        return "SPNEGO";
    }

    @Override
    public String getInfo() {
        return "org.apache.catalina.authenticator.SpnegoAuthenticator/1.0";
    }

    @Override
    protected void initInternal() throws LifecycleException {
        String jaasConf;
        super.initInternal();
        String krb5Conf = System.getProperty("java.security.krb5.conf");
        if (krb5Conf == null) {
            File krb5ConfFile = new File(Bootstrap.getCatalinaBase(), "conf/krb5.ini");
            System.setProperty("java.security.krb5.conf", krb5ConfFile.getAbsolutePath());
        }
        if ((jaasConf = System.getProperty("java.security.auth.login.config")) == null) {
            File jaasConfFile = new File(Bootstrap.getCatalinaBase(), "conf/jaas.conf");
            System.setProperty("java.security.auth.login.config", jaasConfFile.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean authenticate(Request request, HttpServletResponse response, LoginConfig config) throws IOException {
        MessageBytes authorization;
        Principal principal = request.getUserPrincipal();
        String ssoId = (String)request.getNote("org.apache.catalina.request.SSOID");
        if (principal != null) {
            if (log.isDebugEnabled()) {
                log.debug("Already authenticated '" + principal.getName() + "'");
            }
            if (ssoId != null) {
                this.associate(ssoId, request.getSessionInternal(true));
            }
            return true;
        }
        if (ssoId != null) {
            if (log.isDebugEnabled()) {
                log.debug("SSO Id " + ssoId + " set; attempting " + "reauthentication");
            }
            if (this.reauthenticateFromSSO(ssoId, request)) {
                return true;
            }
        }
        if ((authorization = request.getCoyoteRequest().getMimeHeaders().getValue("authorization")) == null) {
            if (log.isDebugEnabled()) {
                log.debug(sm.getString("authenticator.noAuthHeader"));
            }
            response.setHeader("WWW-Authenticate", "Negotiate");
            response.sendError(401);
            return false;
        }
        authorization.toBytes();
        ByteChunk authorizationBC = authorization.getByteChunk();
        if (!authorizationBC.startsWithIgnoreCase("negotiate ", 0)) {
            if (log.isDebugEnabled()) {
                log.debug(sm.getString("spnegoAuthenticator.authHeaderNotNego"));
            }
            response.setHeader("WWW-Authenticate", "Negotiate");
            response.sendError(401);
            return false;
        }
        authorizationBC.setOffset(authorizationBC.getOffset() + 10);
        byte[] decoded = Base64.decodeBase64(authorizationBC.getBuffer(), authorizationBC.getOffset(), authorizationBC.getLength());
        if (decoded.length == 0) {
            if (log.isDebugEnabled()) {
                log.debug(sm.getString("spnegoAuthenticator.authHeaderNoToken"));
            }
            response.setHeader("WWW-Authenticate", "Negotiate");
            response.sendError(401);
            return false;
        }
        LoginContext lc = null;
        GSSContext gssContext = null;
        byte[] outToken = null;
        try {
            try {
                lc = new LoginContext(this.getLoginConfigName());
                lc.login();
            }
            catch (LoginException e) {
                log.error(sm.getString("spnegoAuthenticator.serviceLoginFail"), e);
                response.sendError(500);
                boolean bl = false;
                if (gssContext != null) {
                    try {
                        gssContext.dispose();
                    }
                    catch (GSSException e2) {
                        // empty catch block
                    }
                }
                if (lc != null) {
                    try {
                        lc.logout();
                    }
                    catch (LoginException e3) {
                        // empty catch block
                    }
                }
                return bl;
            }
            Subject subject = lc.getSubject();
            final GSSManager manager = GSSManager.getInstance();
            final int credentialLifetime = Globals.IS_IBM_JVM ? Integer.MAX_VALUE : 0;
            PrivilegedExceptionAction<GSSCredential> action = new PrivilegedExceptionAction<GSSCredential>(){

                @Override
                public GSSCredential run() throws GSSException {
                    return manager.createCredential(null, credentialLifetime, new Oid("1.3.6.1.5.5.2"), 2);
                }
            };
            gssContext = manager.createContext(Subject.doAs(subject, action));
            outToken = Subject.doAs(lc.getSubject(), new AcceptAction(gssContext, decoded));
            if (outToken == null) {
                if (log.isDebugEnabled()) {
                    log.debug(sm.getString("spnegoAuthenticator.ticketValidateFail"));
                }
                response.setHeader("WWW-Authenticate", "Negotiate");
                response.sendError(401);
                boolean bl = false;
                return bl;
            }
            principal = Subject.doAs(subject, new AuthenticateAction(this.context.getRealm(), gssContext, this.storeDelegatedCredential));
        }
        catch (GSSException e) {
            if (log.isDebugEnabled()) {
                log.debug(sm.getString("spnegoAuthenticator.ticketValidateFail"), e);
            }
            response.setHeader("WWW-Authenticate", "Negotiate");
            response.sendError(401);
            boolean manager = false;
            return manager;
        }
        catch (PrivilegedActionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof GSSException) {
                if (log.isDebugEnabled()) {
                    log.debug(sm.getString("spnegoAuthenticator.serviceLoginFail"), e);
                }
            } else {
                log.error(sm.getString("spnegoAuthenticator.serviceLoginFail"), e);
            }
            response.setHeader("WWW-Authenticate", "Negotiate");
            response.sendError(401);
            boolean bl = false;
            return bl;
        }
        finally {
            if (gssContext != null) {
                try {
                    gssContext.dispose();
                }
                catch (GSSException e) {}
            }
            if (lc != null) {
                try {
                    lc.logout();
                }
                catch (LoginException e) {}
            }
        }
        response.setHeader("WWW-Authenticate", "Negotiate " + Base64.encodeBase64String(outToken));
        if (principal != null) {
            MessageBytes ua;
            this.register(request, response, principal, "SPNEGO", principal.getName(), null);
            Pattern p = this.noKeepAliveUserAgents;
            if (p != null && (ua = request.getCoyoteRequest().getMimeHeaders().getValue("user-agent")) != null && p.matcher(ua.toString()).matches()) {
                response.setHeader("Connection", "close");
            }
            return true;
        }
        response.sendError(401);
        return false;
    }

    private static class AuthenticateAction
    implements PrivilegedAction<Principal> {
        private final Realm realm;
        private final GSSContext gssContext;
        private final boolean storeDelegatedCredential;

        public AuthenticateAction(Realm realm, GSSContext gssContext, boolean storeDelegatedCredential) {
            this.realm = realm;
            this.gssContext = gssContext;
            this.storeDelegatedCredential = storeDelegatedCredential;
        }

        @Override
        public Principal run() {
            return this.realm.authenticate(this.gssContext, this.storeDelegatedCredential);
        }
    }

    private static class AcceptAction
    implements PrivilegedExceptionAction<byte[]> {
        GSSContext gssContext;
        byte[] decoded;

        AcceptAction(GSSContext context, byte[] decodedToken) {
            this.gssContext = context;
            this.decoded = decodedToken;
        }

        @Override
        public byte[] run() throws GSSException {
            return this.gssContext.acceptSecContext(this.decoded, 0, this.decoded.length);
        }
    }
}

